/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public abstract class BoundedDiagnosingMatcher<S, T extends S>
extends BaseMatcher<S> {
    private final Matcher<Class<?>> matcher;

    public BoundedDiagnosingMatcher(Class<? extends S> expectedType) {
        this.matcher = Matchers.instanceOf((Class)((Class)Checks.checkNotNull(expectedType)));
    }

    public BoundedDiagnosingMatcher(Class<? extends S> expectedType, Class<?> interfaceType1, Class<?> ... otherInterfaces) {
        int interfaceCount = otherInterfaces.length + 2;
        ArrayList<Matcher> instanceMatchers = new ArrayList<Matcher>(interfaceCount);
        instanceMatchers.add(Matchers.instanceOf((Class)((Class)Checks.checkNotNull(expectedType))));
        Checks.checkNotNull(otherInterfaces);
        instanceMatchers.add(Matchers.instanceOf((Class)((Class)Checks.checkNotNull(interfaceType1))));
        Checks.checkArgument((boolean)interfaceType1.isInterface());
        for (Class<?> intfType : otherInterfaces) {
            instanceMatchers.add(Matchers.instanceOf((Class)((Class)Checks.checkNotNull(intfType))));
            Checks.checkArgument((boolean)intfType.isInterface());
        }
        this.matcher = Matchers.allOf(instanceMatchers);
    }

    protected abstract boolean matchesSafely(T var1, Description var2);

    protected abstract void describeMoreTo(Description var1);

    public final void describeTo(Description description) {
        this.matcher.describeTo(description);
        StringDescription implDescription = new StringDescription();
        this.describeMoreTo((Description)implDescription);
        String implDescriptionString = implDescription.toString();
        if (!implDescriptionString.isEmpty()) {
            description.appendText(" and ").appendText(implDescriptionString);
        }
    }

    public final boolean matches(Object item) {
        return item != null && this.matcher.matches(item) && this.matchesSafely(item, Description.NONE);
    }

    public final void describeMismatch(Object item, Description mismatchDescription) {
        if (item == null) {
            mismatchDescription.appendText("was null");
        } else if (!this.matcher.matches(item)) {
            this.matcher.describeMismatch(item, mismatchDescription);
        } else {
            this.matchesSafely(item, mismatchDescription);
        }
    }
}

