/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.internal.data.model;

import androidx.test.espresso.internal.data.model.ActionData;
import androidx.test.espresso.internal.data.model.ScreenData;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0010R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0019"}, d2={"Landroidx/test/espresso/internal/data/model/TestFlow;", "", "()V", "allScreenData", "Ljava/util/ArrayList;", "Landroidx/test/espresso/internal/data/model/ScreenData;", "Lkotlin/collections/ArrayList;", "head", "getHead", "()Landroidx/test/espresso/internal/data/model/ScreenData;", "setHead", "(Landroidx/test/espresso/internal/data/model/ScreenData;)V", "tail", "getTail", "setTail", "addScreen", "", "screen", "action", "Landroidx/test/espresso/internal/data/model/ActionData;", "getEdge", "index", "", "getSize", "resetTraversal", "espresso_core_java_androidx_test_espresso_internal_data_model-model_kt"})
public final class TestFlow {
    @Nullable
    private ScreenData head;
    @Nullable
    private ScreenData tail;
    @NotNull
    private final ArrayList<ScreenData> allScreenData = new ArrayList();

    @Nullable
    public final ScreenData getHead() {
        return this.head;
    }

    public final void setHead(@Nullable ScreenData screenData) {
        this.head = screenData;
    }

    @Nullable
    public final ScreenData getTail() {
        return this.tail;
    }

    public final void setTail(@Nullable ScreenData screenData) {
        this.tail = screenData;
    }

    public final void addScreen(@NotNull ScreenData screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        this.allScreenData.add(screen);
        if (this.head == null) {
            this.head = screen;
        }
        ScreenData screenData = this.tail;
        if (screenData != null) {
            ScreenData screenData2 = this.tail;
            Intrinsics.checkNotNull((Object)screenData2);
            screenData.addAction(new ActionData(screenData2, screen));
        }
        this.tail = screen;
    }

    public final void addScreen(@NotNull ScreenData screen, @NotNull ActionData action) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.allScreenData.add(screen);
        if (this.head == null) {
            this.head = screen;
        }
        ScreenData screenData = this.tail;
        Intrinsics.checkNotNull((Object)screenData);
        screenData.addAction(action);
        this.tail = screen;
    }

    public final int getSize() {
        return this.allScreenData.size();
    }

    public final void resetTraversal() {
        for (ScreenData screenData : this.allScreenData) {
            screenData.setActionIndex(0);
        }
    }

    @Nullable
    public final ActionData getEdge(int index) {
        if (this.head == null) {
            return null;
        }
        ScreenData screenData = this.head;
        Intrinsics.checkNotNull((Object)screenData);
        ScreenData curr = screenData;
        this.resetTraversal();
        while (!((Collection)curr.getActions()).isEmpty()) {
            ActionData nextAction = curr.getActions().get(curr.getActionIndex());
            ScreenData screenData2 = curr;
            int n = screenData2.getActionIndex();
            screenData2.setActionIndex(n + 1);
            if (nextAction.getIndex() != null) {
                Integer n2 = nextAction.getIndex();
                if (n2 != null && index == n2) {
                    return nextAction;
                }
            }
            curr = nextAction.getDest();
        }
        return null;
    }
}

