/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.internal.data;

import android.graphics.Rect;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.internal.data.model.ActionData;
import androidx.test.espresso.internal.data.model.ScreenData;
import androidx.test.espresso.internal.data.model.TestArtifact;
import androidx.test.espresso.internal.data.model.TestFlow;
import androidx.test.espresso.internal.data.model.ViewData;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import androidx.test.platform.io.PlatformTestStorage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class TestFlowVisualizer {
    private static TestFlowVisualizer testFlowVisualizer;
    private static final String TEST_FLOW_ARG = "enable_testflow_gallery";
    private final TestFlow testFlow;
    private final PlatformTestStorage platformTestStorage;
    private static final String LOG_TAG = "TestFlowVisualizer";
    private int actionIndex = 0;
    private Boolean enabled;

    TestFlowVisualizer(PlatformTestStorage testStorage) {
        this(testStorage, new TestFlow());
    }

    @VisibleForTesting
    TestFlowVisualizer(PlatformTestStorage testStorage, TestFlow testFlow) {
        this.platformTestStorage = (PlatformTestStorage)Checks.checkNotNull((Object)testStorage);
        this.testFlow = (TestFlow)Checks.checkNotNull((Object)testFlow);
    }

    public static TestFlowVisualizer getInstance(PlatformTestStorage platformTestStorage) {
        if (testFlowVisualizer != null) {
            if (TestFlowVisualizer.testFlowVisualizer.platformTestStorage != platformTestStorage) {
                throw new IllegalStateException("getInstance called with different instance of PlatformTestStorage.");
            }
        } else {
            testFlowVisualizer = new TestFlowVisualizer(platformTestStorage);
        }
        return testFlowVisualizer;
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = this.platformTestStorage.getInputArgs().containsKey(TEST_FLOW_ARG) && Boolean.parseBoolean(this.platformTestStorage.getInputArg(TEST_FLOW_ARG));
        }
        return this.enabled;
    }

    public int getLastActionIndexAndIncrement() {
        int index = this.actionIndex++;
        return index;
    }

    public int getLastActionIndex() {
        return this.actionIndex;
    }

    public void beforeActionRecordData(ActionData actionData, View view) {
        Checks.checkState((boolean)Thread.currentThread().equals(Looper.getMainLooper().getThread()), (String)"Method cannot be called off the main application thread (on: %s)", (Object[])new Object[]{Thread.currentThread().getName()});
        Checks.checkNotNull((Object)actionData, (Object)"Requires actionData to store in graph.");
        Checks.checkNotNull((Object)view, (Object)"Requires View to analyze.");
        if (actionData.getIndex() == null) {
            throw new IllegalStateException("ActionData must have a distinguishing index.");
        }
        if (this.testFlow.getEdge(actionData.getIndex()) != null) {
            throw new IllegalStateException("Currently appending to existing ActionData objects is not supported.");
        }
        Rect visibleParts = new Rect();
        view.getGlobalVisibleRect(visibleParts);
        ScreenData screen = new ScreenData();
        screen.addViewData(new ViewData(view.toString(), this.adjustViewCoords(view), visibleParts));
        this.testFlow.addScreen(screen);
    }

    public void afterActionRecordData(ActionData actionData) {
        Checks.checkState((boolean)Thread.currentThread().equals(Looper.getMainLooper().getThread()), (String)"Method cannot be called off the main application thread (on: %s)", (Object[])new Object[]{Thread.currentThread().getName()});
        Checks.checkNotNull((Object)actionData, (Object)"Requires ActionData to store in graph.");
        ScreenData currScreen = this.testFlow.getTail();
        ScreenData nextScreen = new ScreenData();
        actionData.source = currScreen;
        actionData.dest = nextScreen;
        this.testFlow.addScreen(nextScreen, actionData);
    }

    public void beforeActionGenerateTestArtifact(int actionIndex) {
        TestOutputEmitter.takeScreenshot((String)("screenshot-before-" + actionIndex + ".png"));
    }

    public void afterActionGenerateTestArtifact(int actionIndex) {
        TestOutputEmitter.takeScreenshot((String)("screenshot-after-" + actionIndex + ".png"));
    }

    private Rect adjustViewCoords(View view) {
        float[] tl = GeneralLocation.TOP_LEFT.calculateCoordinates(view);
        float[] br = GeneralLocation.BOTTOM_RIGHT.calculateCoordinates(view);
        br[1] = Math.min(br[1], 800.0f);
        return new Rect((int)tl[0], (int)tl[1], (int)br[0], (int)br[1]);
    }

    public void visualize() {
        try (PrintStream writer = new PrintStream(this.platformTestStorage.openOutputFile("output_gallery.html"));){
            ScreenData curr = this.testFlow.getHead();
            if (curr == null) {
                Log.d((String)LOG_TAG, (String)"Exiting process 'visualize()', TestFlow graph is empty.");
                return;
            }
            this.testFlow.resetTraversal();
            this.setStyling(writer);
            int actionCounter = 0;
            while (!curr.getActions().isEmpty() && curr.getActionIndex() < curr.getActions().size()) {
                this.beginActionOutput(writer);
                String pathname = "screenshot-before-" + actionCounter + ".png";
                curr.addArtifact(new TestArtifact(pathname, ".png"));
                this.displayScreenshot(pathname, writer);
                if (curr.getActions().isEmpty()) {
                    return;
                }
                ActionData action = curr.getActions().get(curr.getActionIndex());
                List<ViewData> views = curr.getViews();
                if (action.getDesc() != null) {
                    if (!action.getDesc().contains("scroll") && !curr.getViews().isEmpty()) {
                        for (ViewData element : views) {
                            this.displayViewData(element, writer);
                        }
                    } else {
                        writer.append("<div class=\"action-item\">");
                    }
                    this.displayActionData(action, writer);
                } else if (!views.isEmpty()) {
                    for (ViewData element : views) {
                        this.displayViewData(element, writer);
                    }
                }
                ScreenData temp = action.getDest();
                curr.setActionIndex(curr.getActionIndex() + 1);
                pathname = "screenshot-after-" + actionCounter + ".png";
                curr.addArtifact(new TestArtifact(pathname, ".png"));
                this.displayScreenshot(pathname, writer);
                if (!temp.getActions().isEmpty() && temp.getActions().get(temp.getActionIndex()) != null) {
                    curr = temp.getActions().get(temp.getActionIndex()).getDest();
                    temp.setActionIndex(temp.getActionIndex() + 1);
                }
                this.endActionOutput(writer);
                ++actionCounter;
            }
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Exception thrown while trying to display TestFlow.", (Throwable)e);
        }
    }

    private void displayViewData(ViewData viewData, PrintStream writer) {
        Rect viewBox = viewData.getViewBox();
        Rect visible = viewData.getVisibleViewBox();
        int x0 = viewBox.left;
        int x1 = viewBox.right;
        int y0 = viewBox.top;
        int y1 = viewBox.bottom;
        writer.append(String.format(Locale.ENGLISH, "<div style=\"border:3px solid rgba(255, 0, 0, .5); width:%d; height:%d", visible.right - visible.left, visible.bottom - (visible.top + 3)));
        writer.append(String.format(Locale.ENGLISH, "px; position:absolute; top:%dpx; left: %dpx; z-index:10;\"></div>", visible.top - 3, visible.left - 3));
        writer.append(String.format(Locale.ENGLISH, "<div style=\"border:3px solid rgba(0, 0, 255, .5); width:%s; height:%s", x1 - x0, y1 - (y0 + 3)));
        writer.append(String.format(Locale.ENGLISH, "; position:absolute; top:%spx; left: %spx; z-index:9;\"></div>", y0 - 3, x0 - 3));
        writer.append("<div class=\"action-item\">");
        writer.append("<div style=\"border:3px solid rgba(255, 0, 0, .5);\">Visible View</div>");
        writer.append("<div style=\"border:3px solid rgba(0, 0, 255, .5);\">Actual View</div>");
        writer.append(String.format(Locale.ENGLISH, "<p>%s</p>", viewData.getDesc()));
        writer.append(String.format("View: %s<br />", viewBox));
        writer.append(String.format(Locale.ENGLISH, "<p>Visible portion: %s</p>", Objects.requireNonNull(visible)));
        float percentVisible = Math.max(Math.min(((float)visible.bottom - (float)visible.top) / (float)(y1 - y0), 1.0f) * Math.min(((float)visible.right - (float)visible.left) / (float)(x1 - x0), 1.0f) * 100.0f, 0.0f);
        writer.append(String.format(Locale.ENGLISH, "This view is %s%% visible.", Float.valueOf(percentVisible)));
    }

    private void displayActionData(ActionData action, PrintStream writer) {
        if (action.getName() != null) {
            writer.append(String.format(Locale.getDefault(), "<p>Classname: %s</p>", action.getName()));
        }
        if (action.getDesc() != null) {
            writer.append(String.format(Locale.getDefault(), "<p>Description: %s</p>", action.getDesc()));
        }
        if (action.getConstraints() != null) {
            writer.append(String.format(Locale.getDefault(), "<p>Constraints: %s</p>", action.getConstraints().replace('<', '(').replace('>', ')')));
        }
        writer.append("</div>");
    }

    private void beginActionOutput(PrintStream writer) {
        writer.append("<div class=\"action\"><div style=\"position:relative; display:inline-block;\">");
    }

    private void endActionOutput(PrintStream writer) {
        writer.append("</div></div>");
    }

    private void setStyling(PrintStream writer) {
        writer.append("<style>\n.action-item {\ndisplay:inline-block;\nwidth:450px;\n");
        writer.append("margin-left:10px;\nmargin-right:10px;\n}\n</style>");
    }

    private void displayScreenshot(String pathname, PrintStream writer) {
        writer.append("<div style=\"width:480px; display: inline-block\">");
        writer.append(String.format(Locale.ENGLISH, "<img src=\"./%s\" />\n", pathname));
        writer.append("</div>");
    }
}

