/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.dagger.internal;

import androidx.test.espresso.core.internal.deps.dagger.internal.Factory;
import androidx.test.espresso.core.internal.deps.dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DelegateFactory<T>
implements Factory<T> {
    private Provider<T> delegate;

    public T get() {
        if (this.delegate == null) {
            throw new IllegalStateException();
        }
        return (T)this.delegate.get();
    }

    @Deprecated
    public void setDelegatedProvider(Provider<T> delegate) {
        DelegateFactory.setDelegate(this, delegate);
    }

    public static <T> void setDelegate(Provider<T> delegateFactory, Provider<T> delegate) {
        Preconditions.checkNotNull(delegate);
        DelegateFactory asDelegateFactory = (DelegateFactory)delegateFactory;
        if (asDelegateFactory.delegate != null) {
            throw new IllegalStateException();
        }
        asDelegateFactory.delegate = delegate;
    }

    Provider<T> getDelegate() {
        return Preconditions.checkNotNull(this.delegate);
    }
}

