/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.util.Log;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.test.espresso.RootViewException;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.Throwables;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.io.PlatformTestStorageRegistry;
import androidx.test.services.storage.TestStorageException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;

class ViewHierarchyExceptionHandler<T extends Throwable>
extends DefaultFailureHandler.TypedFailureHandler<T> {
    private static final String TAG = ViewHierarchyExceptionHandler.class.getSimpleName();
    private static final int MAX_MSG_SIZE = 63488;
    private static final String VIEW_HIERARCHY_CHAR_LIMIT = "view_hierarchy_char_limit";
    private final AtomicInteger failureCount;
    private final Truncater<T> truncater;

    public ViewHierarchyExceptionHandler(AtomicInteger failureCount, Class<T> expectedType, Truncater<T> truncater) {
        super(expectedType);
        this.failureCount = failureCount;
        this.truncater = truncater;
    }

    @Override
    public void handleSafely(T exception, Matcher<View> viewMatcher) {
        String viewHierarchyFile = this.dumpFullViewHierarchyToFile(exception);
        ((Throwable)exception).setStackTrace(Thread.currentThread().getStackTrace());
        int msgLen = this.getMsgLen();
        Throwable error = this.truncater.truncateExceptionMessage(exception, msgLen, viewHierarchyFile);
        Throwables.throwIfUnchecked(error);
        throw new RuntimeException(error);
    }

    private int getMsgLen() {
        PlatformTestStorage testStorage = PlatformTestStorageRegistry.getInstance();
        try {
            String limit;
            if (testStorage.getInputArgs().containsKey(VIEW_HIERARCHY_CHAR_LIMIT) && (limit = testStorage.getInputArg(VIEW_HIERARCHY_CHAR_LIMIT)) != null) {
                return Integer.parseInt(limit);
            }
        }
        catch (TestStorageException | NumberFormatException e) {
            Log.e((String)TAG, (String)"Failed to parse input argument view_hierarchy_char_limit", (Throwable)e);
        }
        return 63488;
    }

    @Nullable
    private String dumpFullViewHierarchyToFile(T error) {
        String viewHierarchyMsg = HumanReadables.getViewHierarchyErrorMessage(((RootViewException)error).getRootView(), null, "", null);
        String viewHierarchyFile = "view-hierarchy-" + this.failureCount + ".txt";
        try {
            this.addOutputFile(viewHierarchyFile, viewHierarchyMsg);
            Log.w((String)TAG, (String)("The complete view hierarchy is available in artifact file '" + viewHierarchyFile + "'."));
            return viewHierarchyFile;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Failed to save the view hierarchy to file " + viewHierarchyFile), (Throwable)e);
            return null;
        }
    }

    private void addOutputFile(String filename, String content) throws IOException {
        try (OutputStream out = PlatformTestStorageRegistry.getInstance().openOutputFile(filename);){
            out.write(content.getBytes());
        }
    }

    static interface Truncater<T> {
        public Throwable truncateExceptionMessage(T var1, int var2, String var3);
    }
}

