/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.IterablesKt;
import androidx.test.espresso.util.Iterators;
import androidx.test.espresso.util.StringJoinerKt;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.internal.util.Checks;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import org.hamcrest.Matcher;

public final class ViewFinderImpl
implements ViewFinder {
    private final Matcher<View> viewMatcher;
    private final Provider<View> rootViewProvider;

    @Inject
    ViewFinderImpl(Matcher<View> viewMatcher, Provider<View> rootViewProvider) {
        this.viewMatcher = viewMatcher;
        this.rootViewProvider = rootViewProvider;
    }

    @Override
    public View getView() throws AmbiguousViewMatcherException, NoMatchingViewException {
        Checks.checkMainThread();
        Checks.checkNotNull(this.viewMatcher);
        View root = (View)this.rootViewProvider.get();
        Iterator<View> matchedViewIterator = IterablesKt.filter(TreeIterables.breadthFirstViewTraversal(root), this.viewMatcher).iterator();
        View matchedView = null;
        while (matchedViewIterator.hasNext()) {
            if (matchedView != null) {
                throw new AmbiguousViewMatcherException.Builder().withViewMatcher(this.viewMatcher).withRootView(root).withView1(matchedView).withView2(matchedViewIterator.next()).withOtherAmbiguousViews(Iterators.toArray(matchedViewIterator, View.class)).build();
            }
            matchedView = matchedViewIterator.next();
        }
        if (null == matchedView) {
            List<View> adapterViews = IterablesKt.filterToList(TreeIterables.breadthFirstViewTraversal(root), ViewMatchers.isAssignableFrom(AdapterView.class));
            if (adapterViews.isEmpty()) {
                throw new NoMatchingViewException.Builder().withViewMatcher(this.viewMatcher).withRootView(root).build();
            }
            String warning = String.format(Locale.ROOT, "\nIf the target view is not part of the view hierarchy, you may need to use Espresso.onData to load it from one of the following AdapterViews:%s", StringJoinerKt.joinToString(adapterViews, "\n- "));
            throw new NoMatchingViewException.Builder().withViewMatcher(this.viewMatcher).withRootView(root).withAdapterViews(adapterViews).withAdapterViewWarning(warning).build();
        }
        return matchedView;
    }
}

