/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.annotation.RestrictTo;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.UiControllerImpl;
import androidx.test.espresso.core.internal.deps.dagger.Module;
import androidx.test.espresso.core.internal.deps.dagger.Provides;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import javax.inject.Singleton;

@Module
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class UiControllerModule {
    @Provides
    @Singleton
    public UiController provideUiController(UiControllerImpl uiControllerImpl) {
        androidx.test.platform.ui.UiController platformUiController = (androidx.test.platform.ui.UiController)ServiceLoaderWrapper.loadSingleServiceOrNull(androidx.test.platform.ui.UiController.class);
        if (platformUiController == null) {
            return uiControllerImpl;
        }
        return new EspressoUiControllerAdapter(platformUiController);
    }

    private static class EspressoUiControllerAdapter
    implements InterruptableUiController {
        private final androidx.test.platform.ui.UiController platformUiController;

        private EspressoUiControllerAdapter(androidx.test.platform.ui.UiController platformUiController) {
            this.platformUiController = platformUiController;
        }

        @Override
        public boolean injectMotionEvent(MotionEvent event) throws InjectEventSecurityException {
            try {
                return this.platformUiController.injectMotionEvent(event);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException e) {
                throw new InjectEventSecurityException(e);
            }
        }

        @Override
        public boolean injectKeyEvent(KeyEvent event) throws InjectEventSecurityException {
            try {
                return this.platformUiController.injectKeyEvent(event);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException e) {
                throw new InjectEventSecurityException(e);
            }
        }

        @Override
        public boolean injectString(String str) throws InjectEventSecurityException {
            try {
                return this.platformUiController.injectString(str);
            }
            catch (androidx.test.platform.ui.InjectEventSecurityException e) {
                throw new InjectEventSecurityException(e);
            }
        }

        @Override
        public void loopMainThreadUntilIdle() {
            this.platformUiController.loopMainThreadUntilIdle();
        }

        @Override
        public void loopMainThreadForAtLeast(long millisDelay) {
            this.platformUiController.loopMainThreadForAtLeast(millisDelay);
        }

        @Override
        public void interruptEspressoTasks() {
        }
    }
}

