/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.annotation.SuppressLint;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.IdlingPolicy;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.CompatAsyncTask;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingUiController;
import androidx.test.espresso.base.Interrogator;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.NoopIdleNotificationCallbackIdleNotifierProvider;
import androidx.test.espresso.base.NoopRunnableIdleNotifier;
import androidx.test.espresso.base.SdkAsyncTask;
import androidx.test.espresso.util.StringJoinerKt;
import androidx.test.espresso.util.Throwables;
import androidx.test.espresso.util.concurrent.ThreadFactoryBuilder;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
final class UiControllerImpl
implements InterruptableUiController,
Handler.Callback,
IdlingUiController {
    private static final String TAG = UiControllerImpl.class.getSimpleName();
    private static final Callable<Void> NO_OP = new Callable<Void>(){

        @Override
        public Void call() {
            return null;
        }
    };
    private final EventInjector eventInjector;
    private final BitSet conditionSet;
    private final ExecutorService keyEventExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Espresso Key Event #%d").build());
    private final Looper mainLooper;
    private final IdlingResourceRegistry idlingResourceRegistry;
    private final Handler controllerHandler;
    private MainThreadInterrogation interrogation;
    private int generation = 0;
    private IdleNotifier<Runnable> asyncIdle;
    private IdleNotifier<Runnable> compatIdle;
    private Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> dynamicIdleProvider;

    @Inject
    @VisibleForTesting
    UiControllerImpl(EventInjector eventInjector, @SdkAsyncTask IdleNotifier<Runnable> asyncIdle, @CompatAsyncTask IdleNotifier<Runnable> compatIdle, Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>> dynamicIdle, Looper mainLooper, IdlingResourceRegistry idlingResourceRegistry) {
        this.eventInjector = (EventInjector)Checks.checkNotNull((Object)eventInjector);
        this.asyncIdle = (IdleNotifier)Checks.checkNotNull(asyncIdle);
        this.compatIdle = (IdleNotifier)Checks.checkNotNull(compatIdle);
        this.conditionSet = IdleCondition.createConditionSet();
        this.dynamicIdleProvider = (Provider)Checks.checkNotNull(dynamicIdle);
        this.mainLooper = (Looper)Checks.checkNotNull((Object)mainLooper);
        this.idlingResourceRegistry = (IdlingResourceRegistry)Checks.checkNotNull((Object)idlingResourceRegistry);
        this.controllerHandler = new Handler(mainLooper, (Handler.Callback)this);
    }

    @Override
    public boolean injectKeyEvent(final KeyEvent event) throws InjectEventSecurityException {
        Checks.checkNotNull((Object)event);
        Checks.checkState((Looper.myLooper() == this.mainLooper ? 1 : 0) != 0, (Object)"Expecting to be on main thread!");
        this.loopMainThreadUntilIdle();
        SignalingTask<Boolean> injectTask = new SignalingTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return UiControllerImpl.this.eventInjector.injectKeyEvent(event);
            }
        }, IdleCondition.KEY_INJECT_HAS_COMPLETED, this.generation);
        Future<?> possiblyIgnoredError = this.keyEventExecutor.submit(injectTask);
        this.loopUntil(IdleCondition.KEY_INJECT_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Checks.checkState((boolean)injectTask.isDone(), (Object)"Key injection was signaled - but it wasnt done.");
            return (Boolean)injectTask.get();
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof InjectEventSecurityException) {
                throw (InjectEventSecurityException)((Object)ee.getCause());
            }
            throw new RuntimeException(ee.getCause());
        }
        catch (InterruptedException neverHappens) {
            throw new RuntimeException("impossible.", neverHappens);
        }
    }

    @Override
    public boolean injectMotionEvent(final MotionEvent event) throws InjectEventSecurityException {
        Checks.checkNotNull((Object)event);
        Checks.checkState((Looper.myLooper() == this.mainLooper ? 1 : 0) != 0, (Object)"Expecting to be on main thread!");
        SignalingTask<Boolean> injectTask = new SignalingTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return UiControllerImpl.this.eventInjector.injectMotionEvent(event);
            }
        }, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, this.generation);
        Future<?> possiblyIgnoredError = this.keyEventExecutor.submit(injectTask);
        this.loopUntil(IdleCondition.MOTION_INJECTION_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Checks.checkState((boolean)injectTask.isDone(), (Object)"Motion event injection was signaled - but it wasnt done.");
            boolean bl = (Boolean)injectTask.get();
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof InjectEventSecurityException) {
                throw (InjectEventSecurityException)((Object)ee.getCause());
            }
            Throwables.throwIfUnchecked(ee.getCause() != null ? ee.getCause() : ee);
            throw new RuntimeException(ee.getCause() != null ? ee.getCause() : ee);
        }
        catch (InterruptedException neverHappens) {
            throw new RuntimeException(neverHappens);
        }
        finally {
            this.loopMainThreadUntilIdle();
        }
    }

    @Override
    public boolean injectMotionEventSequence(Iterable<MotionEvent> events) throws InjectEventSecurityException {
        Checks.checkNotNull(events);
        Checks.checkState((boolean)events.iterator().hasNext(), (Object)"Expecting non-empty events to inject");
        Checks.checkState((Looper.myLooper() == this.mainLooper ? 1 : 0) != 0, (Object)"Expecting to be on main thread!");
        final Iterator<MotionEvent> mei = events.iterator();
        long downTime = events.iterator().next().getEventTime();
        final long shift = SystemClock.uptimeMillis() - downTime;
        SignalingTask<Boolean> injectTask = new SignalingTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean success = true;
                while (mei.hasNext()) {
                    MotionEvent me = (MotionEvent)mei.next();
                    long desiredTime = me.getEventTime() + shift;
                    long timeUntilDesired = desiredTime - SystemClock.uptimeMillis();
                    if (timeUntilDesired > 10L) {
                        SystemClock.sleep((long)timeUntilDesired);
                    }
                    if (mei.hasNext()) {
                        success &= UiControllerImpl.this.eventInjector.injectMotionEventAsync(me);
                        continue;
                    }
                    success &= UiControllerImpl.this.eventInjector.injectMotionEvent(me);
                }
                return success;
            }
        }, IdleCondition.MOTION_INJECTION_HAS_COMPLETED, this.generation);
        Future<?> possiblyIgnoredError = this.keyEventExecutor.submit(injectTask);
        this.loopUntil(IdleCondition.MOTION_INJECTION_HAS_COMPLETED, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        try {
            Checks.checkState((boolean)injectTask.isDone(), (Object)"MotionEvents injection was signaled - but it wasnt done.");
            boolean bl = (Boolean)injectTask.get();
            return bl;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof InjectEventSecurityException) {
                throw (InjectEventSecurityException)((Object)ee.getCause());
            }
            Throwables.throwIfUnchecked(ee.getCause() != null ? ee.getCause() : ee);
            throw new RuntimeException(ee.getCause() != null ? ee.getCause() : ee);
        }
        catch (InterruptedException neverHappens) {
            throw new RuntimeException(neverHappens);
        }
        finally {
            this.loopMainThreadUntilIdle();
        }
    }

    @Override
    public boolean injectString(String str) throws InjectEventSecurityException {
        Checks.checkNotNull((Object)str);
        Checks.checkState((Looper.myLooper() == this.mainLooper ? 1 : 0) != 0, (Object)"Expecting to be on main thread!");
        if (str.isEmpty()) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return true;
        }
        boolean eventInjected = false;
        KeyCharacterMap keyCharacterMap = UiControllerImpl.getKeyCharacterMap();
        KeyEvent[] events = keyCharacterMap.getEvents(str.toCharArray());
        if (events == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "Failed to get key events for string %s (i.e. current IME does not understand how to translate the string into key events). As a workaround, you can use replaceText action to set the text directly in the EditText field.", str));
        }
        Log.d((String)TAG, (String)String.format(Locale.ROOT, "Injecting string: \"%s\"", str));
        for (KeyEvent event : events) {
            Checks.checkNotNull((Object)event, (Object)String.format(Locale.ROOT, "Failed to get event for character (%c) with key code (%s)", event.getKeyCode(), event.getUnicodeChar()));
            eventInjected = false;
            for (int attempts = 0; !eventInjected && attempts < 4; ++attempts) {
                event = KeyEvent.changeTimeRepeat((KeyEvent)event, (long)SystemClock.uptimeMillis(), (int)0);
                eventInjected = this.injectKeyEvent(event);
            }
            if (eventInjected) continue;
            Log.e((String)TAG, (String)String.format(Locale.ROOT, "Failed to inject event for character (%c) with key code (%s)", event.getUnicodeChar(), event.getKeyCode()));
            break;
        }
        return eventInjected;
    }

    @SuppressLint(value={"InlinedApi"})
    @VisibleForTesting
    public static KeyCharacterMap getKeyCharacterMap() {
        return KeyCharacterMap.load((int)-1);
    }

    @Override
    public IdlingResourceRegistry getIdlingResourceRegistry() {
        return this.idlingResourceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loopMainThreadUntilIdle() {
        Checks.checkState((Looper.myLooper() == this.mainLooper ? 1 : 0) != 0, (Object)"Expecting to be on main thread!");
        IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> dynamicIdle = (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)this.dynamicIdleProvider.get();
        do {
            EnumSet<IdleCondition> condChecks = EnumSet.noneOf(IdleCondition.class);
            if (!this.asyncIdle.isIdleNow()) {
                this.asyncIdle.registerNotificationCallback(new SignalingTask<Void>(NO_OP, IdleCondition.ASYNC_TASKS_HAVE_IDLED, this.generation));
                condChecks.add(IdleCondition.ASYNC_TASKS_HAVE_IDLED);
            }
            if (!this.compatIdle.isIdleNow()) {
                this.compatIdle.registerNotificationCallback(new SignalingTask<Void>(NO_OP, IdleCondition.COMPAT_TASKS_HAVE_IDLED, this.generation));
                condChecks.add(IdleCondition.COMPAT_TASKS_HAVE_IDLED);
            }
            if (!dynamicIdle.isIdleNow()) {
                final IdlingPolicy warning = IdlingPolicies.getDynamicIdlingResourceWarningPolicy();
                final IdlingPolicy error = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
                final SignalingTask<Void> idleSignal = new SignalingTask<Void>(NO_OP, IdleCondition.DYNAMIC_TASKS_HAVE_IDLED, this.generation);
                dynamicIdle.registerNotificationCallback(new IdlingResourceRegistry.IdleNotificationCallback(){

                    @Override
                    public void resourcesStillBusyWarning(List<String> busyResourceNames) {
                        warning.handleTimeout(busyResourceNames, "IdlingResources are still busy!");
                    }

                    @Override
                    public void resourcesHaveTimedOut(List<String> busyResourceNames) {
                        error.handleTimeout(busyResourceNames, "IdlingResources have timed out!");
                        UiControllerImpl.this.controllerHandler.post((Runnable)idleSignal);
                    }

                    @Override
                    public void allResourcesIdle() {
                        UiControllerImpl.this.controllerHandler.post((Runnable)idleSignal);
                    }
                });
                condChecks.add(IdleCondition.DYNAMIC_TASKS_HAVE_IDLED);
            }
            try {
                dynamicIdle = this.loopUntil(condChecks, dynamicIdle);
            }
            finally {
                this.asyncIdle.cancelCallback();
                this.compatIdle.cancelCallback();
                dynamicIdle.cancelCallback();
            }
        } while (!this.asyncIdle.isIdleNow() || !this.compatIdle.isIdleNow() || !dynamicIdle.isIdleNow());
    }

    @Override
    public void loopMainThreadForAtLeast(long millisDelay) {
        Checks.checkState((Looper.myLooper() == this.mainLooper ? 1 : 0) != 0, (Object)"Expecting to be on main thread!");
        Checks.checkState((!IdleCondition.DELAY_HAS_PAST.isSignaled(this.conditionSet) ? 1 : 0) != 0, (Object)"recursion detected!");
        Checks.checkArgument((millisDelay > 0L ? 1 : 0) != 0);
        this.controllerHandler.postAtTime(new SignalingTask<Void>(NO_OP, IdleCondition.DELAY_HAS_PAST, this.generation), (Object)this.generation, SystemClock.uptimeMillis() + millisDelay);
        this.loopUntil(IdleCondition.DELAY_HAS_PAST, (IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>)((IdleNotifier)this.dynamicIdleProvider.get()));
        this.loopMainThreadUntilIdle();
    }

    public boolean handleMessage(Message msg) {
        if (!IdleCondition.handleMessage(msg, this.conditionSet, this.generation)) {
            Log.i((String)TAG, (String)("Unknown message type: " + msg));
            return false;
        }
        return true;
    }

    private void loopUntil(IdleCondition condition, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> dynamicIdle) {
        this.loopUntil(EnumSet.of(condition), dynamicIdle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> loopUntil(EnumSet<IdleCondition> conditions, IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> dynamicIdle) {
        IdlingPolicy masterIdlePolicy = IdlingPolicies.getMasterIdlingPolicy();
        IdlingPolicy dynamicIdlePolicy = IdlingPolicies.getDynamicIdlingResourceErrorPolicy();
        try {
            long start = SystemClock.uptimeMillis();
            long end = start + masterIdlePolicy.getIdleTimeoutUnit().toMillis(masterIdlePolicy.getIdleTimeout());
            this.interrogation = new MainThreadInterrogation(conditions, this.conditionSet, end);
            InterrogationStatus result = Interrogator.loopAndInterrogate(this.interrogation);
            if (InterrogationStatus.COMPLETED == result) {
                IdleNotifier idleNotifier = dynamicIdle;
                return idleNotifier;
            }
            if (InterrogationStatus.INTERRUPTED == result) {
                Log.w((String)TAG, (String)"Espresso interrogation of the main thread is interrupted");
                throw new RuntimeException("Espresso interrogation of the main thread is interrupted");
            }
            ArrayList<String> idleConditions = new ArrayList<String>();
            for (IdleCondition condition : conditions) {
                if (condition.isSignaled(this.conditionSet)) continue;
                String conditionName = condition.name();
                switch (condition) {
                    case ASYNC_TASKS_HAVE_IDLED: {
                        if (!masterIdlePolicy.getDisableOnTimeout() && (masterIdlePolicy.getTimeoutIfDebuggerAttached() || !Debug.isDebuggerConnected())) break;
                        this.asyncIdle.cancelCallback();
                        this.asyncIdle = new NoopRunnableIdleNotifier();
                        break;
                    }
                    case COMPAT_TASKS_HAVE_IDLED: {
                        if (!masterIdlePolicy.getDisableOnTimeout() && (masterIdlePolicy.getTimeoutIfDebuggerAttached() || !Debug.isDebuggerConnected())) break;
                        this.compatIdle.cancelCallback();
                        this.compatIdle = new NoopRunnableIdleNotifier();
                        break;
                    }
                    case DYNAMIC_TASKS_HAVE_IDLED: {
                        if (dynamicIdlePolicy.getDisableOnTimeout() || !masterIdlePolicy.getTimeoutIfDebuggerAttached() && Debug.isDebuggerConnected()) {
                            dynamicIdle.cancelCallback();
                            this.dynamicIdleProvider = new NoopIdleNotificationCallbackIdleNotifierProvider();
                            dynamicIdle = (IdleNotifier)this.dynamicIdleProvider.get();
                        }
                        List<String> busyResources = this.idlingResourceRegistry.getBusyResources();
                        conditionName = String.format(Locale.ROOT, "%s(busy resources=%s)", conditionName, StringJoinerKt.joinToString(busyResources, ","));
                        break;
                    }
                }
                idleConditions.add(conditionName);
            }
            if (idleConditions.isEmpty()) {
                idleConditions.add("MAIN_LOOPER_HAS_IDLED(last message: " + this.interrogation.getMessage() + ")");
            }
            masterIdlePolicy.handleTimeout(idleConditions, String.format(Locale.ROOT, "Looped for %s iterations over %s %s.", this.interrogation.execCount, masterIdlePolicy.getIdleTimeout(), masterIdlePolicy.getIdleTimeoutUnit().name()));
        }
        finally {
            ++this.generation;
            for (IdleCondition condition : conditions) {
                condition.reset(this.conditionSet);
            }
            this.interrogation = null;
        }
        return dynamicIdle;
    }

    @Override
    public void interruptEspressoTasks() {
        this.controllerHandler.post(new Runnable(){

            @Override
            public void run() {
                if (UiControllerImpl.this.interrogation != null) {
                    UiControllerImpl.this.interrogation.interruptInterrogation();
                    UiControllerImpl.this.controllerHandler.removeCallbacksAndMessages((Object)UiControllerImpl.this.generation);
                }
            }
        });
    }

    private class SignalingTask<T>
    extends FutureTask<T> {
        private final IdleCondition condition;
        private final int myGeneration;

        public SignalingTask(Callable<T> callable, IdleCondition condition, int myGeneration) {
            super(callable);
            this.condition = (IdleCondition)((Object)Checks.checkNotNull((Object)((Object)condition)));
            this.myGeneration = myGeneration;
        }

        @Override
        protected void done() {
            UiControllerImpl.this.controllerHandler.sendMessage(this.condition.createSignal(UiControllerImpl.this.controllerHandler, this.myGeneration));
        }
    }

    private static final class MainThreadInterrogation
    implements Interrogator.InterrogationHandler<InterrogationStatus> {
        private final EnumSet<IdleCondition> conditions;
        private final BitSet conditionSet;
        private final long giveUpAtMs;
        private String lastMessage;
        private InterrogationStatus status = InterrogationStatus.COMPLETED;
        private int execCount = 0;

        MainThreadInterrogation(EnumSet<IdleCondition> conditions, BitSet conditionSet, long giveUpAtMs) {
            this.conditions = conditions;
            this.conditionSet = conditionSet;
            this.giveUpAtMs = giveUpAtMs;
        }

        @Override
        public void setMessage(Message m) {
            try {
                this.lastMessage = m.toString();
            }
            catch (NullPointerException npe) {
                this.lastMessage = "NPE calling message toString(): " + npe;
            }
        }

        @Override
        public String getMessage() {
            return this.lastMessage;
        }

        @Override
        public void quitting() {
        }

        @Override
        public boolean barrierUp() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean queueEmpty() {
            return !this.conditionsMet();
        }

        @Override
        public boolean taskDueSoon() {
            return this.continueOrTimeout();
        }

        @Override
        public boolean taskDueLong() {
            return !this.conditionsMet();
        }

        @Override
        public boolean beforeTaskDispatch() {
            ++this.execCount;
            return this.continueOrTimeout();
        }

        private boolean continueOrTimeout() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return false;
            }
            if (SystemClock.uptimeMillis() >= this.giveUpAtMs) {
                this.status = InterrogationStatus.TIMED_OUT;
                return false;
            }
            return true;
        }

        void interruptInterrogation() {
            this.status = InterrogationStatus.INTERRUPTED;
        }

        @Override
        public InterrogationStatus get() {
            return this.status;
        }

        private boolean conditionsMet() {
            if (InterrogationStatus.INTERRUPTED == this.status) {
                return true;
            }
            boolean conditionsMet = true;
            boolean shouldLogConditionState = this.execCount > 0 && this.execCount % 100 == 0;
            for (IdleCondition condition : this.conditions) {
                if (condition.isSignaled(this.conditionSet)) continue;
                conditionsMet = false;
                if (!shouldLogConditionState) break;
                Log.w((String)TAG, (String)("Waiting for: " + condition.name() + " for " + this.execCount + " iterations."));
            }
            return conditionsMet;
        }
    }

    private static enum InterrogationStatus {
        TIMED_OUT,
        COMPLETED,
        INTERRUPTED;

    }

    static enum IdleCondition {
        DELAY_HAS_PAST,
        ASYNC_TASKS_HAVE_IDLED,
        COMPAT_TASKS_HAVE_IDLED,
        KEY_INJECT_HAS_COMPLETED,
        MOTION_INJECTION_HAS_COMPLETED,
        DYNAMIC_TASKS_HAVE_IDLED;


        public boolean isSignaled(BitSet conditionSet) {
            return conditionSet.get(this.ordinal());
        }

        public void reset(BitSet conditionSet) {
            conditionSet.set(this.ordinal(), false);
        }

        public Message createSignal(Handler handler, int myGeneration) {
            return Message.obtain((Handler)handler, (int)this.ordinal(), (int)myGeneration, (int)0, null);
        }

        public static boolean handleMessage(Message message, BitSet conditionSet, int currentGeneration) {
            IdleCondition[] allConditions = IdleCondition.values();
            if (message.what < 0 || message.what >= allConditions.length) {
                return false;
            }
            IdleCondition condition = allConditions[message.what];
            if (message.arg1 == currentGeneration) {
                condition.signal(conditionSet);
            } else {
                Log.w((String)TAG, (String)("ignoring signal of: " + (Object)((Object)condition) + " from previous generation: " + message.arg1 + " current generation: " + currentGeneration));
            }
            return true;
        }

        public static BitSet createConditionSet() {
            return new BitSet(IdleCondition.values().length);
        }

        protected void signal(BitSet conditionSet) {
            conditionSet.set(this.ordinal());
        }
    }
}

