/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import androidx.test.espresso.Root;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.internal.util.Checks;
import androidx.test.platform.view.inspector.WindowInspectorCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

final class RootsOracle
implements ActiveRootLister {
    private static final String TAG = RootsOracle.class.getSimpleName();
    private final Looper mainLooper;

    @Inject
    RootsOracle(Looper mainLooper) {
        this.mainLooper = mainLooper;
    }

    @Override
    public List<Root> listActiveRoots() {
        Checks.checkState((boolean)this.mainLooper.equals(Looper.myLooper()), (Object)"must be called on main thread.");
        try {
            ArrayList<Root> roots = new ArrayList<Root>();
            for (View view : this.reverse(WindowInspectorCompat.getGlobalWindowViews())) {
                roots.add(new Root.Builder().withDecorView(view).withWindowLayoutParams((WindowManager.LayoutParams)view.getLayoutParams()).build());
            }
            return Collections.unmodifiableList(roots);
        }
        catch (WindowInspectorCompat.ViewRetrievalException e) {
            Log.w((String)TAG, (String)"Failed to retrieve root views", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<View> reverse(List<View> globalWindowViews) {
        Collections.reverse(globalWindowViews);
        return globalWindowViews;
    }
}

