/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.NoMatchingRootException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.ConfigurationSynchronizationUtils;
import androidx.test.espresso.base.RootViewPickerScope;
import androidx.test.espresso.internal.inject.TargetContext;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.LogUtil;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.Stage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Provider;
import org.hamcrest.Matcher;

@RootViewPickerScope
public final class RootViewPicker
implements Provider<View> {
    private static final String TAG = RootViewPicker.class.getSimpleName();
    private static final List<Integer> CREATED_WAIT_TIMES = Collections.unmodifiableList(Arrays.asList(10, 50, 150, 250));
    private static final List<Integer> RESUMED_WAIT_TIMES = Collections.unmodifiableList(Arrays.asList(10, 50, 100, 500, 2000, 30000));
    private final UiController uiController;
    private final ActivityLifecycleMonitor activityLifecycleMonitor;
    private final AtomicReference<Boolean> needsActivity;
    private final RootResultFetcher rootResultFetcher;
    private final ControlledLooper controlledLooper;
    private final Context appContext;

    @Inject
    RootViewPicker(UiController uiController, RootResultFetcher rootResultFetcher, ActivityLifecycleMonitor activityLifecycleMonitor, AtomicReference<Boolean> needsActivity, ControlledLooper controlledLooper, @TargetContext Context appContext) {
        this.uiController = uiController;
        this.rootResultFetcher = rootResultFetcher;
        this.activityLifecycleMonitor = activityLifecycleMonitor;
        this.needsActivity = needsActivity;
        this.controlledLooper = controlledLooper;
        this.appContext = appContext;
    }

    public View get() {
        Checks.checkState((boolean)Looper.getMainLooper().equals(Looper.myLooper()), (Object)"must be called on main thread.");
        if (this.needsActivity.get().booleanValue()) {
            this.waitForAtLeastOneActivityToBeResumed();
        }
        return this.pickRootView();
    }

    private Root waitForRootToBeReady(Root pickedRoot) {
        long timeout = SystemClock.uptimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        RootReadyBackoff rootReadyBackoff = new RootReadyBackoff();
        while (SystemClock.uptimeMillis() <= timeout) {
            if (pickedRoot.isReady()) {
                return pickedRoot;
            }
            this.controlledLooper.simulateWindowFocus(pickedRoot.getDecorView());
            this.uiController.loopMainThreadForAtLeast(((BackOff)rootReadyBackoff).getNextBackoffInMillis());
        }
        throw new RootViewWithoutFocusException(String.format(Locale.ROOT, "Waited for the root of the view hierarchy to have window focus and not request layout for 10 seconds. If you specified a non default root matcher, it may be picking a root that never takes focus. Root:\n%s", pickedRoot));
    }

    private Root pickARoot() {
        long timeout = SystemClock.uptimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        RootResults rootResults = this.rootResultFetcher.fetch();
        NoActiveRootsBackoff noActiveRootsBackoff = new NoActiveRootsBackoff();
        NoMatchingRootBackoff noMatchingRootBackoff = new NoMatchingRootBackoff();
        while (SystemClock.uptimeMillis() <= timeout) {
            switch (rootResults.getState()) {
                case ROOTS_PICKED: {
                    return rootResults.getPickedRoot();
                }
                case NO_ROOTS_PRESENT: {
                    this.uiController.loopMainThreadForAtLeast(((BackOff)noActiveRootsBackoff).getNextBackoffInMillis());
                    break;
                }
                case NO_ROOTS_PICKED: {
                    this.uiController.loopMainThreadForAtLeast(((BackOff)noMatchingRootBackoff).getNextBackoffInMillis());
                }
            }
            rootResults = this.rootResultFetcher.fetch();
        }
        if (RootResults.State.ROOTS_PICKED == rootResults.getState()) {
            return rootResults.getPickedRoot();
        }
        throw NoMatchingRootException.create((Matcher<Root>)rootResults.rootSelector, rootResults.allRoots);
    }

    private View pickRootView() {
        return this.waitForRootToBeReady(this.pickARoot()).getDecorView();
    }

    private void waitForAtLeastOneActivityToBeResumed() {
        Collection resumedActivities = this.activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        if (resumedActivities.isEmpty()) {
            this.uiController.loopMainThreadUntilIdle();
            resumedActivities = this.activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
        }
        if (resumedActivities.isEmpty()) {
            long waitTime;
            Iterator<Integer> iterator;
            List<Activity> activities = this.getAllActiveActivities();
            if (activities.isEmpty()) {
                iterator = CREATED_WAIT_TIMES.iterator();
                while (iterator.hasNext()) {
                    waitTime = iterator.next().intValue();
                    Log.w((String)TAG, (String)("No activities found - waiting: " + waitTime + "ms for one to appear."));
                    this.uiController.loopMainThreadForAtLeast(waitTime);
                    activities = this.getAllActiveActivities();
                    if (activities.isEmpty()) continue;
                    break;
                }
            }
            if (activities.isEmpty()) {
                throw new NoActivityResumedException("No activities found. Did you forget to launch the activity by calling getActivity() or startActivitySync or similar?");
            }
            iterator = RESUMED_WAIT_TIMES.iterator();
            while (iterator.hasNext()) {
                waitTime = iterator.next().intValue();
                Log.w((String)TAG, (String)("No activity currently resumed - waiting: " + waitTime + "ms for one to appear."));
                this.uiController.loopMainThreadForAtLeast(waitTime);
                resumedActivities = this.activityLifecycleMonitor.getActivitiesInStage(Stage.RESUMED);
                if (resumedActivities.isEmpty()) continue;
                return;
            }
            throw new NoActivityResumedException("No activities in stage RESUMED. Did you forget to launch the activity. (test.getActivity() or similar)?");
        }
        Activity currentActivity = (Activity)resumedActivities.toArray()[0];
        ConfigurationSynchronizationUtils.waitForConfigurationChangesOnActivity(currentActivity, this.uiController, this.appContext);
    }

    private List<Activity> getAllActiveActivities() {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (Stage s : EnumSet.range(Stage.PRE_ON_CREATE, Stage.RESTARTED)) {
            activities.addAll(this.activityLifecycleMonitor.getActivitiesInStage(s));
        }
        return activities;
    }

    private static final class RootViewWithoutFocusException
    extends RuntimeException
    implements EspressoException {
        private RootViewWithoutFocusException(String message) {
            super(message);
        }
    }

    private static final class RootReadyBackoff
    extends BackOff {
        private static final List<Integer> ROOT_READY_BACKOFF = Collections.unmodifiableList(Arrays.asList(10, 25, 50, 100, 200, 400, 800, 1000));

        public RootReadyBackoff() {
            super(ROOT_READY_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long waitTime = this.getBackoffForAttempt();
            Log.d((String)TAG, (String)String.format(Locale.ROOT, "Root not ready - waiting: %sms for one to appear.", waitTime));
            return waitTime;
        }
    }

    private static final class NoMatchingRootBackoff
    extends BackOff {
        private static final List<Integer> NO_MATCHING_ROOT_BACKOFF = Collections.unmodifiableList(Arrays.asList(10, 20, 200, 400, 1000, 2000));

        public NoMatchingRootBackoff() {
            super(NO_MATCHING_ROOT_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long waitTime = this.getBackoffForAttempt();
            Log.d((String)TAG, (String)String.format(Locale.ROOT, "No matching root available - waiting: %sms for one to appear.", waitTime));
            return waitTime;
        }
    }

    private static final class NoActiveRootsBackoff
    extends BackOff {
        private static final List<Integer> NO_ACTIVE_ROOTS_BACKOFF = Collections.unmodifiableList(Arrays.asList(10, 10, 20, 30, 50, 80, 130, 210, 340));

        public NoActiveRootsBackoff() {
            super(NO_ACTIVE_ROOTS_BACKOFF, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getNextBackoffInMillis() {
            long waitTime = this.getBackoffForAttempt();
            LogUtil.logDebugWithProcess((String)TAG, (String)"No active roots available - waiting: %sms for one to appear.", (Object[])new Object[]{waitTime});
            return waitTime;
        }
    }

    private static abstract class BackOff {
        private final List<Integer> backoffTimes;
        private final TimeUnit timeUnit;
        private int numberOfAttempts = 0;

        public BackOff(List<Integer> backoffTimes, TimeUnit timeUnit) {
            this.backoffTimes = backoffTimes;
            this.timeUnit = timeUnit;
        }

        protected abstract long getNextBackoffInMillis();

        protected final long getBackoffForAttempt() {
            if (this.numberOfAttempts >= this.backoffTimes.size()) {
                return this.backoffTimes.get(this.backoffTimes.size() - 1).intValue();
            }
            int backoffTime = this.backoffTimes.get(this.numberOfAttempts);
            ++this.numberOfAttempts;
            return this.timeUnit.toMillis(backoffTime);
        }
    }

    static class RootResultFetcher {
        private final Matcher<Root> selector;
        private final ActiveRootLister activeRootLister;

        @Inject
        public RootResultFetcher(ActiveRootLister activeRootLister, AtomicReference<Matcher<Root>> rootMatcherRef) {
            this.activeRootLister = activeRootLister;
            this.selector = rootMatcherRef.get();
        }

        public RootResults fetch() {
            List<Root> allRoots = this.activeRootLister.listActiveRoots();
            ArrayList<Root> pickedRoots = new ArrayList<Root>();
            for (Root root : allRoots) {
                if (!this.selector.matches((Object)root)) continue;
                pickedRoots.add(root);
            }
            return new RootResults(allRoots, pickedRoots, this.selector);
        }
    }

    private static class RootResults {
        private final List<Root> allRoots;
        private final List<Root> pickedRoots;
        private final Matcher<Root> rootSelector;

        private RootResults(List<Root> allRoots, List<Root> pickedRoots, Matcher<Root> rootSelector) {
            this.allRoots = allRoots;
            this.pickedRoots = pickedRoots;
            this.rootSelector = rootSelector;
        }

        private static boolean isTopmostRoot(Root topMostRoot, Root root) {
            return root.getWindowLayoutParams().get().type > topMostRoot.getWindowLayoutParams().get().type;
        }

        public State getState() {
            if (this.allRoots.isEmpty()) {
                return State.NO_ROOTS_PRESENT;
            }
            if (this.pickedRoots.isEmpty()) {
                return State.NO_ROOTS_PICKED;
            }
            if (this.pickedRoots.size() >= 1) {
                return State.ROOTS_PICKED;
            }
            return State.NO_ROOTS_PICKED;
        }

        private Root getRootFromMultipleRoots() {
            Root topMostRoot = this.pickedRoots.get(0);
            if (this.pickedRoots.size() >= 1) {
                for (Root currentRoot : this.pickedRoots) {
                    if (RootMatchers.isDialog().matches((Object)currentRoot)) {
                        return currentRoot;
                    }
                    if (!RootResults.isTopmostRoot(topMostRoot, currentRoot)) continue;
                    topMostRoot = currentRoot;
                }
            }
            return topMostRoot;
        }

        public Root getPickedRoot() {
            if (this.pickedRoots.size() > 1) {
                LogUtil.logDebugWithProcess((String)TAG, (String)"Multiple root windows detected: %s", (Object[])new Object[]{this.pickedRoots});
                return this.getRootFromMultipleRoots();
            }
            return this.pickedRoots.get(0);
        }

        static enum State {
            NO_ROOTS_PRESENT,
            NO_ROOTS_PICKED,
            ROOTS_PICKED;

        }
    }
}

