/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.view.View;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.internal.util.Checks;
import org.hamcrest.Matcher;

class PerformExceptionHandler
extends DefaultFailureHandler.TypedFailureHandler<PerformException> {
    private final Context appContext;

    public PerformExceptionHandler(Context appContext, Class<PerformException> expectedType) {
        super(expectedType);
        this.appContext = (Context)Checks.checkNotNull((Object)appContext);
    }

    @Override
    public void handleSafely(PerformException error, Matcher<View> viewMatcher) {
        StringBuilder sb = new StringBuilder();
        if (!PerformExceptionHandler.isAnimationAndTransitionDisabled(this.appContext)) {
            sb.append("Animations or transitions are enabled on the target device.\nFor more info check: https://developer.android.com/training/testing/espresso/setup#set-up-environment\n\n");
        }
        sb.append(viewMatcher);
        throw new PerformException.Builder().from(error).withViewDescription(sb.toString()).build();
    }

    private static boolean isAnimationAndTransitionDisabled(Context context) {
        ContentResolver resolver = context.getContentResolver();
        boolean isTransitionAnimationDisabled = PerformExceptionHandler.isEqualToZero(PerformExceptionHandler.getTransitionAnimationScale(resolver));
        boolean isWindowAnimationDisabled = PerformExceptionHandler.isEqualToZero(PerformExceptionHandler.getWindowAnimationScale(resolver));
        boolean isAnimatorDisabled = PerformExceptionHandler.isEqualToZero(PerformExceptionHandler.getAnimatorDurationScale(resolver));
        return isTransitionAnimationDisabled && isWindowAnimationDisabled && isAnimatorDisabled;
    }

    private static boolean isEqualToZero(float value) {
        return Float.compare(Math.abs(value), 0.0f) == 0;
    }

    private static float getTransitionAnimationScale(ContentResolver resolver) {
        return PerformExceptionHandler.getSetting(resolver, "transition_animation_scale", "transition_animation_scale");
    }

    private static float getWindowAnimationScale(ContentResolver resolver) {
        return PerformExceptionHandler.getSetting(resolver, "window_animation_scale", "window_animation_scale");
    }

    private static float getAnimatorDurationScale(ContentResolver resolver) {
        return PerformExceptionHandler.getSetting(resolver, "animator_duration_scale", "animator_duration_scale");
    }

    private static float getSetting(ContentResolver resolver, String current, String deprecated) {
        return PerformExceptionHandler.getGlobalSetting(resolver, current);
    }

    private static float getGlobalSetting(ContentResolver resolver, String setting) {
        try {
            return Settings.Global.getFloat((ContentResolver)resolver, (String)setting);
        }
        catch (Settings.SettingNotFoundException e) {
            return 0.0f;
        }
    }
}

