/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.base.Interrogator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

class LooperIdlingResourceInterrogationHandler
implements Interrogator.InterrogationHandler<Void>,
IdlingResource {
    private static final ConcurrentHashMap<String, LooperIdlingResourceInterrogationHandler> insts = new ConcurrentHashMap();
    private final Interrogator.QueueInterrogationHandler<Boolean> queueHasNewTasks = new Interrogator.QueueInterrogationHandler<Boolean>(){
        private Boolean hasTasks = Boolean.FALSE;

        @Override
        public Boolean get() {
            return this.hasTasks;
        }

        @Override
        public boolean queueEmpty() {
            this.hasTasks = Boolean.FALSE;
            return false;
        }

        @Override
        public boolean taskDueLong() {
            this.hasTasks = Boolean.FALSE;
            return false;
        }

        @Override
        public boolean taskDueSoon() {
            this.hasTasks = Boolean.TRUE;
            return false;
        }

        @Override
        public boolean barrierUp() {
            this.hasTasks = Boolean.TRUE;
            return false;
        }
    };
    private final String name;
    private volatile boolean started = false;
    private volatile MessageQueue queue = null;
    private volatile boolean idle = true;
    private volatile IdlingResource.ResourceCallback cb = null;

    private LooperIdlingResourceInterrogationHandler(String name) {
        this.name = name;
    }

    static LooperIdlingResourceInterrogationHandler forLooper(Looper l) {
        LooperIdlingResourceInterrogationHandler ir;
        String name = String.format(Locale.ROOT, "LooperIdlingResource-%s-%s", l.getThread().getId(), l.getThread().getName());
        LooperIdlingResourceInterrogationHandler previous = insts.putIfAbsent(name, ir = new LooperIdlingResourceInterrogationHandler(name));
        if (null != previous) {
            return previous;
        }
        new Handler(l).post(new Runnable(){

            @Override
            public void run() {
                ir.queue = Looper.myQueue();
                ir.started = true;
                Interrogator.loopAndInterrogate(ir);
            }
        });
        return ir;
    }

    @Override
    public void setMessage(Message m) {
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public void quitting() {
        this.transitionToIdle();
    }

    @Override
    public boolean queueEmpty() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean taskDueLong() {
        this.transitionToIdle();
        return true;
    }

    @Override
    public boolean beforeTaskDispatch() {
        this.idle = false;
        return true;
    }

    @Override
    public boolean taskDueSoon() {
        this.idle = false;
        return true;
    }

    @Override
    public boolean barrierUp() {
        this.idle = false;
        return true;
    }

    @Override
    public Void get() {
        return null;
    }

    public boolean isIdleNow() {
        if (!this.started) {
            return false;
        }
        if (this.idle) {
            return Boolean.FALSE.equals(Interrogator.peekAtQueueState(this.queue, this.queueHasNewTasks));
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback cb) {
        this.cb = cb;
    }

    private void transitionToIdle() {
        this.idle = true;
        if (null != this.cb) {
            this.cb.onTransitionToIdle();
        }
    }
}

