/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Binder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import androidx.test.espresso.util.Throwables;
import androidx.test.internal.util.Checks;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Interrogator {
    private static final String TAG = "Interrogator";
    private static final Method messageQueueNextMethod;
    private static final Field messageQueueHeadField;
    private static final Method recycleUncheckedMethod;
    private static final int LOOKAHEAD_MILLIS = 15;
    private static final ThreadLocal<Boolean> interrogating;

    Interrogator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R> R loopAndInterrogate(InterrogationHandler<R> handler) {
        Interrogator.checkSanity();
        interrogating.set(Boolean.TRUE);
        boolean stillInterested = true;
        MessageQueue q = Looper.myQueue();
        long entryIdentity = Binder.clearCallingIdentity();
        try {
            long threadIdentity = Binder.clearCallingIdentity();
            while (stillInterested) {
                stillInterested = Interrogator.interrogateQueueState(q, handler);
                if (!stillInterested) continue;
                Message m = Interrogator.getNextMessage();
                if (null == m) {
                    handler.quitting();
                    Object r = handler.get();
                    return r;
                }
                stillInterested = handler.beforeTaskDispatch();
                handler.setMessage(m);
                m.getTarget().dispatchMessage(m);
                long newIdentity = Binder.clearCallingIdentity();
                if (newIdentity != threadIdentity) {
                    Log.wtf((String)TAG, (String)("Thread identity changed from 0x" + Long.toHexString(threadIdentity) + " to 0x" + Long.toHexString(newIdentity) + " while dispatching to " + m.getTarget().getClass().getName() + " " + m.getCallback() + " what=" + m.what));
                }
                Interrogator.recycle(m);
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)entryIdentity);
            interrogating.set(Boolean.FALSE);
        }
        return handler.get();
    }

    private static void recycle(Message m) {
        if (recycleUncheckedMethod != null) {
            try {
                recycleUncheckedMethod.invoke((Object)m, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() != null) {
                    Throwables.throwIfUnchecked(ite.getCause());
                    throw new RuntimeException(ite.getCause());
                }
                throw new RuntimeException(ite);
            }
        } else {
            m.recycle();
        }
    }

    private static Message getNextMessage() {
        try {
            return (Message)messageQueueNextMethod.invoke((Object)Looper.myQueue(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    static <R> R peekAtQueueState(MessageQueue q, QueueInterrogationHandler<R> handler) {
        Checks.checkNotNull((Object)q);
        Checks.checkNotNull(handler);
        Checks.checkState((!Interrogator.interrogateQueueState(q, handler) ? 1 : 0) != 0, (String)"It is expected that %s would stop interrogation after a single peak at the queue.", (Object[])new Object[]{handler});
        return handler.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean interrogateQueueState(MessageQueue q, QueueInterrogationHandler<?> handler) {
        MessageQueue messageQueue = q;
        synchronized (messageQueue) {
            Message head;
            try {
                head = (Message)messageQueueHeadField.get(q);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (null == head) {
                return handler.queueEmpty();
            }
            if (null == head.getTarget()) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"barrier is up");
                }
                return handler.barrierUp();
            }
            long headWhen = head.getWhen();
            long nowFuz = SystemClock.uptimeMillis() + 15L;
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("headWhen: " + headWhen + " nowFuz: " + nowFuz + " due long: " + (nowFuz < headWhen)));
            }
            if (nowFuz > headWhen) {
                return handler.taskDueSoon();
            }
            return handler.taskDueLong();
        }
    }

    private static void checkSanity() {
        Checks.checkState((Looper.myLooper() != null ? 1 : 0) != 0, (Object)"Calling non-looper thread!");
        Checks.checkState((boolean)Boolean.FALSE.equals(interrogating.get()), (Object)"Already interrogating!");
    }

    static {
        interrogating = new ThreadLocal<Boolean>(){

            @Override
            public Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        try {
            messageQueueNextMethod = MessageQueue.class.getDeclaredMethod("next", new Class[0]);
            messageQueueNextMethod.setAccessible(true);
            messageQueueHeadField = MessageQueue.class.getDeclaredField("mMessages");
            messageQueueHeadField.setAccessible(true);
        }
        catch (IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            Log.e((String)TAG, (String)"Could not initialize interrogator!", (Throwable)e);
            throw new RuntimeException("Could not initialize interrogator!", e);
        }
        Method recycleUnchecked = null;
        try {
            recycleUnchecked = Message.class.getDeclaredMethod("recycleUnchecked", new Class[0]);
            recycleUnchecked.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        recycleUncheckedMethod = recycleUnchecked;
    }

    static interface InterrogationHandler<R>
    extends QueueInterrogationHandler<R> {
        public boolean beforeTaskDispatch();

        public void quitting();

        public void setMessage(Message var1);

        public String getMessage();
    }

    static interface QueueInterrogationHandler<R> {
        public boolean queueEmpty();

        public boolean taskDueSoon();

        public boolean taskDueLong();

        public boolean barrierUp();

        public R get();
    }
}

