/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class InputManagerEventInjectionStrategy
implements EventInjectionStrategy {
    private static final String TAG = "EventInjectionStrategy";
    private static final long KEYBOARD_DISMISSAL_DELAY_MILLIS = 1000L;
    private boolean initComplete;
    private Method injectInputEventMethod;
    private Method setSourceMotionMethod;
    private Object instanceInputManagerObject;
    private int asyncEventMode;
    private int syncEventMode;

    InputManagerEventInjectionStrategy() {
    }

    InputManagerEventInjectionStrategy initialize() {
        if (this.initComplete) {
            return this;
        }
        try {
            Log.d((String)TAG, (String)"Creating injection strategy with input manager.");
            Class<?> inputManagerClassObject = Class.forName("android.hardware.input.InputManager");
            Method getInstanceMethod = inputManagerClassObject.getDeclaredMethod("getInstance", new Class[0]);
            getInstanceMethod.setAccessible(true);
            this.instanceInputManagerObject = getInstanceMethod.invoke(inputManagerClassObject, new Object[0]);
            this.injectInputEventMethod = this.instanceInputManagerObject.getClass().getDeclaredMethod("injectInputEvent", InputEvent.class, Integer.TYPE);
            this.injectInputEventMethod.setAccessible(true);
            Field motionEventModeField = inputManagerClassObject.getField("INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH");
            motionEventModeField.setAccessible(true);
            this.syncEventMode = motionEventModeField.getInt(inputManagerClassObject);
            if (Build.VERSION.SDK_INT >= 28) {
                this.asyncEventMode = 0;
            } else {
                Field asyncMotionEventModeField = inputManagerClassObject.getField("INJECT_INPUT_EVENT_MODE_ASYNC");
                asyncMotionEventModeField.setAccessible(true);
                this.asyncEventMode = asyncMotionEventModeField.getInt(inputManagerClassObject);
            }
            this.setSourceMotionMethod = MotionEvent.class.getDeclaredMethod("setSource", Integer.TYPE);
            this.initComplete = true;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public boolean injectKeyEvent(KeyEvent keyEvent) throws InjectEventSecurityException {
        try {
            return (Boolean)this.injectInputEventMethod.invoke(this.instanceInputManagerObject, keyEvent, this.syncEventMode);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SecurityException) {
                throw new InjectEventSecurityException(cause);
            }
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new InjectEventSecurityException(e);
        }
    }

    @Override
    public boolean injectMotionEvent(MotionEvent motionEvent, boolean sync) throws InjectEventSecurityException {
        return this.innerInjectMotionEvent(motionEvent, true, sync);
    }

    private boolean innerInjectMotionEvent(MotionEvent motionEvent, boolean shouldRetry, boolean sync) throws InjectEventSecurityException {
        try {
            if ((motionEvent.getSource() & 2) == 0 && !InputManagerEventInjectionStrategy.isFromTouchpadInGlassDevice(motionEvent)) {
                this.setSourceMotionMethod.invoke((Object)motionEvent, 4098);
            }
            int eventMode = sync ? this.syncEventMode : this.asyncEventMode;
            return (Boolean)this.injectInputEventMethod.invoke(this.instanceInputManagerObject, motionEvent, eventMode);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SecurityException) {
                if (shouldRetry) {
                    Log.w((String)TAG, (String)"Error performing a ViewAction! soft keyboard dismissal animation may have been in the way. Retrying once after: 1000 millis");
                    SystemClock.sleep((long)1000L);
                    this.innerInjectMotionEvent(motionEvent, false, sync);
                }
                throw new InjectEventSecurityException("Check if Espresso is clicking outside the app (system dialog, navigation bar if edge-to-edge is enabled, etc.).", cause);
            }
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new InjectEventSecurityException(e);
        }
        return false;
    }

    private static boolean isFromTouchpadInGlassDevice(MotionEvent motionEvent) {
        return (Build.DEVICE.contains("glass") || Build.DEVICE.contains("Glass") || Build.DEVICE.contains("wingman")) && (motionEvent.getSource() & 0x100008) != 0;
    }
}

