/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.MotionEvent;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.base.EventInjectionStrategy;
import androidx.test.internal.util.Checks;

final class EventInjector {
    private static final String TAG = EventInjector.class.getSimpleName();
    private final EventInjectionStrategy injectionStrategy;

    EventInjector(EventInjectionStrategy injectionStrategy) {
        this.injectionStrategy = (EventInjectionStrategy)Checks.checkNotNull((Object)injectionStrategy);
    }

    boolean injectKeyEvent(KeyEvent event) throws InjectEventSecurityException {
        long downTime = event.getDownTime();
        long eventTime = event.getEventTime();
        int action = event.getAction();
        int code = event.getKeyCode();
        int repeatCount = event.getRepeatCount();
        int metaState = event.getMetaState();
        int deviceId = event.getDeviceId();
        int scancode = event.getScanCode();
        int flags = event.getFlags();
        if (eventTime == 0L) {
            eventTime = SystemClock.uptimeMillis();
        }
        if (downTime == 0L) {
            downTime = eventTime;
        }
        int source = event.getSource();
        KeyEvent newEvent = new KeyEvent(downTime, eventTime, action, code, repeatCount, metaState, deviceId, scancode, flags | 8, source);
        return this.injectionStrategy.injectKeyEvent(newEvent);
    }

    boolean injectMotionEvent(MotionEvent event) throws InjectEventSecurityException {
        return this.injectionStrategy.injectMotionEvent(event, true);
    }

    boolean injectMotionEventAsync(MotionEvent event) throws InjectEventSecurityException {
        return this.injectionStrategy.injectMotionEvent(event, false);
    }
}

