/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.util.Throwables;
import org.hamcrest.Matcher;

class EspressoExceptionHandler
extends DefaultFailureHandler.TypedFailureHandler<Throwable> {
    public EspressoExceptionHandler(Class<EspressoException> expectedType) {
        super(expectedType);
    }

    @Override
    public void handleSafely(Throwable error, Matcher<View> viewMatcher) {
        error.setStackTrace(Thread.currentThread().getStackTrace());
        Throwables.throwIfUnchecked(error);
        throw new RuntimeException(error);
    }
}

