/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import androidx.test.core.app.DeviceCapture;
import androidx.test.core.graphics.BitmapStorage;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.base.AssertionErrorHandler;
import androidx.test.espresso.base.EspressoExceptionHandler;
import androidx.test.espresso.base.PerformExceptionHandler;
import androidx.test.espresso.base.ThrowableHandler;
import androidx.test.espresso.base.ViewHierarchyExceptionHandler;
import androidx.test.espresso.internal.inject.TargetContext;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;

public final class DefaultFailureHandler
implements FailureHandler {
    private static final AtomicInteger failureCount = new AtomicInteger(0);
    private final List<FailureHandler> handlers = new ArrayList<FailureHandler>();
    private final boolean captureScreenshotOnFailure;

    public DefaultFailureHandler(@TargetContext Context appContext) {
        this(appContext, true);
    }

    public DefaultFailureHandler(@TargetContext Context appContext, boolean captureScreenshotOnFailure) {
        this.captureScreenshotOnFailure = captureScreenshotOnFailure;
        this.handlers.add(new ViewHierarchyExceptionHandler<NoMatchingViewException>(failureCount, NoMatchingViewException.class, DefaultFailureHandler.getNoMatchingViewExceptionTruncater()));
        this.handlers.add(new ViewHierarchyExceptionHandler<AmbiguousViewMatcherException>(failureCount, AmbiguousViewMatcherException.class, DefaultFailureHandler.getAmbiguousViewMatcherExceptionTruncater()));
        this.handlers.add(new PerformExceptionHandler((Context)Checks.checkNotNull((Object)appContext), PerformException.class));
        this.handlers.add(new AssertionErrorHandler(AssertionFailedError.class, AssertionError.class));
        this.handlers.add(new EspressoExceptionHandler(EspressoException.class));
        this.handlers.add(new ThrowableHandler());
    }

    static ViewHierarchyExceptionHandler.Truncater<NoMatchingViewException> getNoMatchingViewExceptionTruncater() {
        return (exception, msgLen, viewHierarchyFile) -> new NoMatchingViewException.Builder().from((NoMatchingViewException)exception).withMaxMsgLen(msgLen).withViewHierarchyFile(viewHierarchyFile).build();
    }

    static ViewHierarchyExceptionHandler.Truncater<AmbiguousViewMatcherException> getAmbiguousViewMatcherExceptionTruncater() {
        return (exception, msgLen, viewHierarchyFile) -> new AmbiguousViewMatcherException.Builder().from((AmbiguousViewMatcherException)exception).withMaxMsgLen(msgLen).withViewHierarchyFile(viewHierarchyFile).build();
    }

    @Override
    public void handle(Throwable error, Matcher<View> viewMatcher) {
        int count = failureCount.incrementAndGet();
        try {
            TestOutputEmitter.captureWindowHierarchy((String)("explore-window-hierarchy-" + count + ".xml"));
            this.takeScreenshot("view-op-error-" + count);
        }
        catch (RuntimeException screenshotException) {
            error.addSuppressed(screenshotException);
        }
        for (FailureHandler handler : this.handlers) {
            handler.handle(error, viewMatcher);
        }
    }

    private void takeScreenshot(String outputName) {
        if (!this.captureScreenshotOnFailure) {
            return;
        }
        try {
            if (DeviceCapture.canTakeScreenshot()) {
                BitmapStorage.writeToTestStorage((Bitmap)DeviceCapture.takeScreenshotNoSync(), (String)outputName);
            } else {
                TestOutputEmitter.takeScreenshot((String)(outputName + ".png"));
            }
        }
        catch (IOException | Error | RuntimeException e) {
            Log.w((String)"DefaultFailureHandler", (String)"Failed to take screenshot", (Throwable)e);
        }
    }

    static abstract class TypedFailureHandler<T>
    implements FailureHandler {
        private final List<Class<?>> acceptedTypes;

        public TypedFailureHandler(Class<?> ... acceptedTypes) {
            this.acceptedTypes = (List)Checks.checkNotNull(Arrays.asList(acceptedTypes));
        }

        @Override
        public void handle(Throwable error, Matcher<View> viewMatcher) {
            if (error != null) {
                for (Class<?> acceptedType : this.acceptedTypes) {
                    if (!acceptedType.isInstance(error)) continue;
                    this.handleSafely(error, viewMatcher);
                    break;
                }
            }
        }

        abstract void handleSafely(T var1, Matcher<View> var2);
    }
}

