/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.UiController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class ConfigurationSynchronizationUtils {
    private static final String TAG = ConfigurationSynchronizationUtils.class.getSimpleName();
    private static final List<Integer> ORIENTATION_WAIT_TIMES = Collections.unmodifiableList(Arrays.asList(10, 50, 100, 250, 500, 2000));

    private ConfigurationSynchronizationUtils() {
    }

    public static void waitForConfigurationChangesOnActivity(Activity currentActivity, UiController uiController, Context appContext) {
        if (Build.VERSION.SDK_INT >= 24 && currentActivity.isInMultiWindowMode()) {
            return;
        }
        int applicationOrientation = appContext.getResources().getConfiguration().orientation;
        if (applicationOrientation != currentActivity.getResources().getConfiguration().orientation) {
            Iterator<Integer> iterator = ORIENTATION_WAIT_TIMES.iterator();
            while (iterator.hasNext()) {
                long waitTime = iterator.next().intValue();
                Log.w((String)TAG, (String)("Activity's orientation does not match the application's - waiting: " + waitTime + "ms for orientation to update."));
                uiController.loopMainThreadForAtLeast(waitTime);
                if (applicationOrientation != currentActivity.getResources().getConfiguration().orientation) continue;
                return;
            }
            throw new NoActivityResumedException("Timed out waiting for Activity's orientation to update.");
        }
    }
}

