/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RestrictTo;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.AsyncTaskPoolMonitor;
import androidx.test.espresso.base.CompatAsyncTask;
import androidx.test.espresso.base.Default;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.InputManagerEventInjectionStrategy;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.base.NoopRunnableIdleNotifier;
import androidx.test.espresso.base.PlatformTestStorageModule;
import androidx.test.espresso.base.RootsOracle;
import androidx.test.espresso.base.SdkAsyncTask;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor;
import androidx.test.espresso.core.internal.deps.dagger.Module;
import androidx.test.espresso.core.internal.deps.dagger.Provides;
import androidx.test.espresso.internal.inject.TargetContext;
import androidx.test.espresso.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.util.concurrent.ThreadFactoryBuilder;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.platform.tracing.Tracing;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Module(includes={PlatformTestStorageModule.class})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class BaseLayerModule {
    @Provides
    public ActivityLifecycleMonitor provideLifecycleMonitor() {
        return ActivityLifecycleMonitorRegistry.getInstance();
    }

    @Provides
    @TargetContext
    public Context provideTargetContext() {
        return InstrumentationRegistry.getInstrumentation().getTargetContext();
    }

    @Provides
    @Singleton
    public Looper provideMainLooper() {
        return Looper.getMainLooper();
    }

    @Provides
    @Singleton
    @CompatAsyncTask
    public IdleNotifier<Runnable> provideCompatAsyncTaskMonitor(ThreadPoolExecutorExtractor extractor) {
        ThreadPoolExecutor compatThreadPool = extractor.getCompatAsyncTaskThreadPool();
        if (compatThreadPool != null) {
            return new AsyncTaskPoolMonitor(compatThreadPool).asIdleNotifier();
        }
        return new NoopRunnableIdleNotifier();
    }

    @Provides
    @Singleton
    @MainThread
    public Executor provideMainThreadExecutor(Looper mainLooper) {
        final Handler handler = new Handler(mainLooper);
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                handler.post(runnable);
            }
        };
    }

    @Provides
    public IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback> provideDynamicNotifer(IdlingResourceRegistry dynamicRegistry) {
        dynamicRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
        return dynamicRegistry.asIdleNotifier();
    }

    @Provides
    @Singleton
    @SdkAsyncTask
    public IdleNotifier<Runnable> provideSdkAsyncTaskMonitor(ThreadPoolExecutorExtractor extractor) {
        return new AsyncTaskPoolMonitor(extractor.getAsyncTaskThreadPool()).asIdleNotifier();
    }

    @Provides
    public ActiveRootLister provideActiveRootLister(RootsOracle rootsOracle) {
        return rootsOracle;
    }

    @Provides
    @Singleton
    public EventInjector provideEventInjector() {
        return new EventInjector(new InputManagerEventInjectionStrategy().initialize());
    }

    @Provides
    FailureHandler provideFailureHandler(FailureHandlerHolder holder) {
        return holder.get();
    }

    @Provides
    @Singleton
    public ListeningExecutorService provideRemoteExecutor() {
        return new ListeningExecutorService(new ThreadPoolExecutor(0, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Espresso Remote #%d").build()));
    }

    @Provides
    @Default
    FailureHandler provideFailureHander(DefaultFailureHandler impl) {
        return impl;
    }

    @Provides
    DefaultFailureHandler provideDefaultFailureHander(@TargetContext Context context) {
        return new DefaultFailureHandler(context, true);
    }

    @Provides
    @Singleton
    public ControlledLooper provideControlledLooper() {
        return (ControlledLooper)ServiceLoaderWrapper.loadSingleService(ControlledLooper.class, () -> ControlledLooper.NO_OP_CONTROLLED_LOOPER);
    }

    @Provides
    @Singleton
    Tracing providesTracing() {
        return Tracing.getInstance();
    }

    @Singleton
    public static class FailureHandlerHolder {
        private final AtomicReference<FailureHandler> holder;

        @Inject
        public FailureHandlerHolder(@Default FailureHandler defaultHandler) {
            this.holder = new AtomicReference<FailureHandler>(defaultHandler);
        }

        public void update(FailureHandler handler) {
            this.holder.set(handler);
        }

        public FailureHandler get() {
            return this.holder.get();
        }
    }
}

