/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import androidx.test.espresso.base.IdleNotifier;
import androidx.test.internal.util.Checks;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class AsyncTaskPoolMonitor {
    private final AtomicReference<IdleMonitor> monitor = new AtomicReference<Object>(null);
    private final ThreadPoolExecutor pool;
    private final AtomicInteger activeBarrierChecks = new AtomicInteger(0);

    AsyncTaskPoolMonitor(ThreadPoolExecutor pool) {
        this.pool = (ThreadPoolExecutor)Checks.checkNotNull((Object)pool);
    }

    IdleNotifier<Runnable> asIdleNotifier() {
        return new IdleNotifier<Runnable>(){

            @Override
            public boolean isIdleNow() {
                return AsyncTaskPoolMonitor.this.isIdleNow();
            }

            @Override
            public void cancelCallback() {
                AsyncTaskPoolMonitor.this.cancelIdleMonitor();
            }

            @Override
            public void registerNotificationCallback(Runnable r) {
                AsyncTaskPoolMonitor.this.notifyWhenIdle(r);
            }
        };
    }

    boolean isIdleNow() {
        if (!this.pool.getQueue().isEmpty()) {
            return false;
        }
        int activeCount = this.pool.getActiveCount();
        if (0 != activeCount && this.monitor.get() == null) {
            activeCount -= this.activeBarrierChecks.get();
        }
        return 0 == activeCount;
    }

    void notifyWhenIdle(Runnable idleCallback) {
        Checks.checkNotNull((Object)idleCallback);
        IdleMonitor myMonitor = new IdleMonitor(idleCallback);
        Checks.checkState((boolean)this.monitor.compareAndSet(null, myMonitor), (Object)"cannot monitor for idle recursively!");
        myMonitor.monitorForIdle();
    }

    void cancelIdleMonitor() {
        IdleMonitor myMonitor = this.monitor.getAndSet(null);
        if (null != myMonitor) {
            myMonitor.poison();
        }
    }

    private static class BarrierRestarter {
        private final CyclicBarrier barrier;
        private final AtomicInteger barrierGeneration;

        BarrierRestarter(CyclicBarrier barrier, AtomicInteger barrierGeneration) {
            this.barrier = barrier;
            this.barrierGeneration = barrierGeneration;
        }

        synchronized void restart(int fromGeneration) {
            int nextGen = fromGeneration + 1;
            if (this.barrierGeneration.compareAndSet(fromGeneration, nextGen)) {
                this.barrier.reset();
            }
        }
    }

    private class IdleMonitor {
        private final Runnable onIdle;
        private final AtomicInteger barrierGeneration = new AtomicInteger(0);
        private final CyclicBarrier barrier;
        private volatile boolean poisoned;

        private IdleMonitor(final Runnable onIdle) {
            this.onIdle = (Runnable)Checks.checkNotNull((Object)onIdle);
            this.barrier = new CyclicBarrier(AsyncTaskPoolMonitor.this.pool.getCorePoolSize(), new Runnable(){

                @Override
                public void run() {
                    if (AsyncTaskPoolMonitor.this.pool.getQueue().isEmpty()) {
                        AsyncTaskPoolMonitor.this.monitor.compareAndSet(IdleMonitor.this, null);
                        onIdle.run();
                    } else {
                        IdleMonitor.this.monitorForIdle();
                    }
                }
            });
        }

        private void poison() {
            this.poisoned = true;
            this.barrier.reset();
        }

        private void monitorForIdle() {
            if (this.poisoned) {
                return;
            }
            if (AsyncTaskPoolMonitor.this.isIdleNow()) {
                AsyncTaskPoolMonitor.this.monitor.compareAndSet(this, null);
                this.onIdle.run();
            } else {
                int poolSize = AsyncTaskPoolMonitor.this.pool.getCorePoolSize();
                final BarrierRestarter restarter = new BarrierRestarter(this.barrier, this.barrierGeneration);
                for (int i = 0; i < poolSize; ++i) {
                    AsyncTaskPoolMonitor.this.pool.execute(new Runnable(){

                        @Override
                        public void run() {
                            while (!IdleMonitor.this.poisoned) {
                                AsyncTaskPoolMonitor.this.activeBarrierChecks.incrementAndGet();
                                int myGeneration = IdleMonitor.this.barrierGeneration.get();
                                try {
                                    IdleMonitor.this.barrier.await();
                                    return;
                                }
                                catch (InterruptedException ie) {
                                    restarter.restart(myGeneration);
                                }
                                catch (BrokenBarrierException bbe) {
                                    restarter.restart(myGeneration);
                                }
                                finally {
                                    AsyncTaskPoolMonitor.this.activeBarrierChecks.decrementAndGet();
                                }
                            }
                        }
                    });
                }
            }
        }
    }
}

