/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.view.View;
import androidx.test.espresso.base.DefaultFailureHandler;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;

class AssertionErrorHandler
extends DefaultFailureHandler.TypedFailureHandler<Throwable> {
    public AssertionErrorHandler(Class<?> ... expectedTypes) {
        super(expectedTypes);
    }

    @Override
    public void handleSafely(Throwable error, Matcher<View> viewMatcher) {
        AssertionFailedWithCauseError newError = new AssertionFailedWithCauseError(error.getMessage(), error);
        ((Throwable)((Object)newError)).setStackTrace(Thread.currentThread().getStackTrace());
        throw newError;
    }

    static final class AssertionFailedWithCauseError
    extends AssertionFailedError {
        public AssertionFailedWithCauseError(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }
    }
}

