/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.IterablesKt;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewAssertions {
    private static final String TAG = ViewAssertions.class.getSimpleName();

    private ViewAssertions() {
    }

    public static ViewAssertion doesNotExist() {
        return new DoesNotExistViewAssertion();
    }

    public static ViewAssertion matches(Matcher<? super View> viewMatcher) {
        return new MatchesViewAssertion((Matcher)Checks.checkNotNull(viewMatcher));
    }

    public static ViewAssertion selectedDescendantsMatch(Matcher<View> selector, Matcher<View> matcher) {
        return new SelectedDescendantsMatchViewAssertion(selector, matcher);
    }

    @VisibleForTesting
    static class SelectedDescendantsMatchViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;
        @RemoteMsgField(order=1)
        private final Matcher<View> matcher;

        @RemoteMsgConstructor
        private SelectedDescendantsMatchViewAssertion(Matcher<View> selector, Matcher<View> matcher) {
            this.selector = selector;
            this.matcher = matcher;
        }

        @Override
        public void check(View view, NoMatchingViewException noViewException) {
            Checks.checkNotNull((Object)view);
            Iterator<View> selectedViewIterator = IterablesKt.filter(TreeIterables.breadthFirstViewTraversal(view), this.selector).iterator();
            ArrayList<View> nonMatchingViews = new ArrayList<View>();
            while (selectedViewIterator.hasNext()) {
                View selectedView = selectedViewIterator.next();
                if (this.matcher.matches((Object)selectedView)) continue;
                nonMatchingViews.add(selectedView);
            }
            if (nonMatchingViews.size() > 0) {
                String errorMessage = HumanReadables.getViewHierarchyErrorMessage(view, nonMatchingViews, String.format(Locale.ROOT, "At least one view did not match the required matcher: %s", this.matcher), "****DOES NOT MATCH****");
                throw new AssertionFailedError(errorMessage);
            }
        }

        public String toString() {
            return String.format(Locale.ROOT, "SelectedDescendantsMatchViewAssertion{selector=%s, matcher=%s}", this.selector, this.matcher);
        }
    }

    @VisibleForTesting
    static class DoesNotExistViewAssertion
    implements ViewAssertion {
        @RemoteMsgConstructor
        private DoesNotExistViewAssertion() {
        }

        @Override
        public void check(View view, NoMatchingViewException noView) {
            if (view != null) {
                ViewMatchers.assertThat("View is present in the hierarchy: " + HumanReadables.describe(view), true, Matchers.is((Object)false));
            }
        }
    }

    @VisibleForTesting
    static class MatchesViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        @VisibleForTesting
        final Matcher<? super View> viewMatcher;

        @RemoteMsgConstructor
        private MatchesViewAssertion(Matcher<? super View> viewMatcher) {
            this.viewMatcher = viewMatcher;
        }

        @Override
        public void check(View view, NoMatchingViewException noViewException) {
            if (noViewException != null) {
                throw noViewException;
            }
            StringDescription description = new StringDescription();
            description.appendText("'");
            this.viewMatcher.describeTo((Description)description);
            description.appendText("' doesn't match the selected view.");
            ViewMatchers.assertThat(description.toString(), view, this.viewMatcher);
        }

        public String toString() {
            return String.format(Locale.ROOT, "MatchesViewAssertion{viewMatcher=%s}", this.viewMatcher);
        }
    }
}

