/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.IterablesKt;
import androidx.test.espresso.util.Iterators;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.internal.util.Checks;
import java.util.Iterator;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class PositionAssertions {
    private static final String TAG = "PositionAssertions";

    private PositionAssertions() {
    }

    public static ViewAssertion isCompletelyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_LEFT_OF);
    }

    public static ViewAssertion isCompletelyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_RIGHT_OF);
    }

    @Deprecated
    public static ViewAssertion isLeftOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyLeftOf(matcher);
    }

    @Deprecated
    public static ViewAssertion isRightOf(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyRightOf(matcher);
    }

    public static ViewAssertion isPartiallyLeftOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_LEFT_OF);
    }

    public static ViewAssertion isPartiallyRightOf(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_RIGHT_OF);
    }

    public static ViewAssertion isLeftAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.LEFT_ALIGNED);
    }

    public static ViewAssertion isRightAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.RIGHT_ALIGNED);
    }

    public static ViewAssertion isCompletelyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_ABOVE);
    }

    public static ViewAssertion isCompletelyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.COMPLETELY_BELOW);
    }

    public static ViewAssertion isPartiallyAbove(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_ABOVE);
    }

    public static ViewAssertion isPartiallyBelow(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.PARTIALLY_BELOW);
    }

    @Deprecated
    public static ViewAssertion isAbove(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyAbove(matcher);
    }

    @Deprecated
    public static ViewAssertion isBelow(Matcher<View> matcher) {
        return PositionAssertions.isCompletelyBelow(matcher);
    }

    public static ViewAssertion isBottomAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.BOTTOM_ALIGNED);
    }

    public static ViewAssertion isTopAlignedWith(Matcher<View> matcher) {
        return PositionAssertions.relativePositionOf(matcher, Position.TOP_ALIGNED);
    }

    static ViewAssertion relativePositionOf(final Matcher<View> viewMatcher, final Position position) {
        Checks.checkNotNull(viewMatcher);
        return new ViewAssertion(){

            @Override
            public void check(View foundView, NoMatchingViewException noViewException) {
                StringDescription description = new StringDescription();
                if (noViewException != null) {
                    description.appendText(String.format(Locale.ROOT, "' check could not be performed because view '%s' was not found.\n", noViewException.getViewMatcherDescription()));
                    Log.e((String)PositionAssertions.TAG, (String)description.toString());
                    throw noViewException;
                }
                description.appendText("View:").appendText(HumanReadables.describe(foundView)).appendText(" is not ").appendText(position.toString()).appendText(" view ").appendText(viewMatcher.toString());
                ViewMatchers.assertThat(description.toString(), PositionAssertions.isRelativePosition(foundView, PositionAssertions.findView((Matcher<View>)viewMatcher, (View)PositionAssertions.getTopViewGroup(foundView)), position), Matchers.is((Object)true));
            }
        };
    }

    static View findView(Matcher<View> toView, View root) {
        Checks.checkNotNull(toView);
        Checks.checkNotNull((Object)root);
        Iterator<View> matchedViewIterator = IterablesKt.filter(TreeIterables.breadthFirstViewTraversal(root), toView).iterator();
        View matchedView = null;
        while (matchedViewIterator.hasNext()) {
            if (matchedView != null) {
                throw new AmbiguousViewMatcherException.Builder().withRootView(root).withViewMatcher(toView).withView1(matchedView).withView2(matchedViewIterator.next()).withOtherAmbiguousViews(Iterators.toArray(matchedViewIterator, View.class)).build();
            }
            matchedView = matchedViewIterator.next();
        }
        if (matchedView == null) {
            throw new NoMatchingViewException.Builder().withViewMatcher(toView).withRootView(root).build();
        }
        return matchedView;
    }

    private static ViewGroup getTopViewGroup(View view) {
        ViewGroup topView = null;
        for (ViewParent currentParent = view.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (!(currentParent instanceof ViewGroup)) continue;
            topView = (ViewGroup)currentParent;
        }
        return topView;
    }

    static boolean isRelativePosition(View view1, View view2, Position position) {
        int[] location1 = new int[2];
        int[] location2 = new int[2];
        view1.getLocationOnScreen(location1);
        view2.getLocationOnScreen(location2);
        switch (position) {
            case COMPLETELY_LEFT_OF: {
                return location1[0] + view1.getWidth() <= location2[0];
            }
            case COMPLETELY_RIGHT_OF: {
                return location2[0] + view2.getWidth() <= location1[0];
            }
            case COMPLETELY_ABOVE: {
                return location1[1] + view1.getHeight() <= location2[1];
            }
            case COMPLETELY_BELOW: {
                return location2[1] + view2.getHeight() <= location1[1];
            }
            case PARTIALLY_LEFT_OF: {
                return location1[0] < location2[0] && location2[0] < location1[0] + view1.getWidth();
            }
            case PARTIALLY_RIGHT_OF: {
                return location2[0] < location1[0] && location1[0] < location2[0] + view2.getWidth();
            }
            case PARTIALLY_ABOVE: {
                return location1[1] < location2[1] && location2[1] < location1[1] + view1.getHeight();
            }
            case PARTIALLY_BELOW: {
                return location2[1] < location1[1] && location1[1] < location2[1] + view2.getHeight();
            }
            case LEFT_ALIGNED: {
                return location1[0] == location2[0];
            }
            case RIGHT_ALIGNED: {
                return location1[0] + view1.getWidth() == location2[0] + view2.getWidth();
            }
            case TOP_ALIGNED: {
                return location1[1] == location2[1];
            }
            case BOTTOM_ALIGNED: {
                return location1[1] + view1.getHeight() == location2[1] + view2.getHeight();
            }
        }
        return false;
    }

    static enum Position {
        COMPLETELY_LEFT_OF("completely left of"),
        COMPLETELY_RIGHT_OF("completely right of"),
        COMPLETELY_ABOVE("completely above"),
        COMPLETELY_BELOW("completely below"),
        PARTIALLY_LEFT_OF("partially left of"),
        PARTIALLY_RIGHT_OF("partially right of"),
        PARTIALLY_ABOVE("partially above"),
        PARTIALLY_BELOW("partially below"),
        LEFT_ALIGNED("aligned left with"),
        RIGHT_ALIGNED("aligned right with"),
        TOP_ALIGNED("aligned top with"),
        BOTTOM_ALIGNED("aligned bottom with");

        private final String positionValue;

        private Position(String value) {
            this.positionValue = value;
        }

        public String toString() {
            return this.positionValue;
        }
    }
}

