/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.graphics.Rect;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.assertion.ViewAssertions;
import androidx.test.espresso.matcher.LayoutMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.IterablesKt;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.internal.util.Checks;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class LayoutAssertions {
    private LayoutAssertions() {
    }

    public static ViewAssertion noEllipsizedText() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(TextView.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasEllipsizedText()));
    }

    public static ViewAssertion noMultilineButtons() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(Button.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasMultilineText()));
    }

    public static ViewAssertion noOverlaps(Matcher<View> selector) {
        return new NoOverlapsViewAssertion((Matcher)Checks.checkNotNull(selector));
    }

    public static ViewAssertion noOverlaps() {
        return LayoutAssertions.noOverlaps((Matcher<View>)Matchers.allOf(ViewMatchers.withEffectiveVisibility(ViewMatchers.Visibility.VISIBLE), (Matcher)Matchers.anyOf(ViewMatchers.isAssignableFrom(TextView.class), ViewMatchers.isAssignableFrom(ImageView.class))));
    }

    private static Rect getRect(View view) {
        int[] coords = new int[]{0, 0};
        view.getLocationOnScreen(coords);
        return new Rect(coords[0], coords[1], coords[0] + view.getWidth() - 1, coords[1] + view.getHeight() - 1);
    }

    @VisibleForTesting
    static class NoOverlapsViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;

        @RemoteMsgConstructor
        private NoOverlapsViewAssertion(Matcher<View> selector) {
            this.selector = selector;
        }

        @Override
        public void check(View view, NoMatchingViewException noViewException) {
            if (noViewException != null) {
                throw noViewException;
            }
            Iterator<View> selectedViewIterator = IterablesKt.filter(TreeIterables.breadthFirstViewTraversal(view), this.selector).iterator();
            LinkedList<View> prevViews = new LinkedList<View>();
            StringBuilder errorMessage = new StringBuilder();
            while (selectedViewIterator.hasNext()) {
                View selectedView = selectedViewIterator.next();
                Rect viewRect = LayoutAssertions.getRect(selectedView);
                if (viewRect.isEmpty() || selectedView instanceof TextView && ((TextView)selectedView).getText().length() == 0) continue;
                for (View prevView : prevViews) {
                    Rect prevRect;
                    if (selectedView instanceof ImageView && prevView instanceof ImageView || !Rect.intersects((Rect)viewRect, (Rect)(prevRect = LayoutAssertions.getRect(prevView)))) continue;
                    if (errorMessage.length() > 0) {
                        errorMessage.append(",\n\n");
                    }
                    errorMessage.append(String.format(Locale.ROOT, "%s overlaps\n%s", HumanReadables.describe(selectedView), HumanReadables.describe(prevView)));
                    break;
                }
                prevViews.add(selectedView);
            }
            if (errorMessage.length() > 0) {
                throw new AssertionFailedError(errorMessage.toString());
            }
        }

        public String toString() {
            return String.format(Locale.ROOT, "NoOverlapsViewAssertion{selector=%s}", this.selector);
        }
    }
}

