/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.action.CaptureToBitmapAction;
import androidx.test.espresso.action.CloseKeyboardAction;
import androidx.test.espresso.action.EditorAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.GeneralSwipeAction;
import androidx.test.espresso.action.KeyEventAction;
import androidx.test.espresso.action.OpenLinkAction;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.PressBackAction;
import androidx.test.espresso.action.RepeatActionUntilViewState;
import androidx.test.espresso.action.ReplaceTextAction;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.action.Swipe;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.TypeTextAction;
import androidx.test.internal.util.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@CheckReturnValue
public final class ViewActions {
    private static final float EDGE_FUZZ_FACTOR = 0.083f;
    private static Set<Pair<String, ViewAssertion>> globalAssertions = new CopyOnWriteArraySet<Pair<String, ViewAssertion>>();

    private ViewActions() {
    }

    public static void addGlobalAssertion(String name, ViewAssertion viewAssertion) {
        Checks.checkNotNull((Object)name);
        Checks.checkNotNull((Object)viewAssertion);
        Pair vaPair = new Pair((Object)name, (Object)viewAssertion);
        Checks.checkArgument((!globalAssertions.contains(vaPair) ? 1 : 0) != 0, (String)"ViewAssertion with name %s is already in the global assertions!", (Object[])new Object[]{name});
        globalAssertions.add((Pair<String, ViewAssertion>)vaPair);
    }

    public static void removeGlobalAssertion(ViewAssertion viewAssertion) {
        boolean removed = false;
        for (Pair<String, ViewAssertion> vaPair : globalAssertions) {
            if (viewAssertion == null || !viewAssertion.equals(vaPair.second)) continue;
            removed = removed || globalAssertions.remove(vaPair);
        }
        Checks.checkArgument((boolean)removed, (Object)"ViewAssertion was not in global assertions!");
    }

    public static void clearGlobalAssertions() {
        globalAssertions.clear();
    }

    public static ViewAction actionWithAssertions(final ViewAction viewAction) {
        if (globalAssertions.isEmpty()) {
            return viewAction;
        }
        return new ViewAction(){

            @Override
            public String getDescription() {
                StringBuilder msg = new StringBuilder("Running view assertions[");
                for (Pair vaPair : globalAssertions) {
                    msg.append((String)vaPair.first);
                    msg.append(", ");
                }
                msg.append("] and then running: ");
                msg.append(viewAction.getDescription());
                return msg.toString();
            }

            @Override
            public Matcher<View> getConstraints() {
                return viewAction.getConstraints();
            }

            @Override
            public void perform(UiController uic, View view) {
                for (Pair vaPair : globalAssertions) {
                    Log.i((String)"ViewAssertion", (String)("Asserting " + (String)vaPair.first));
                    ((ViewAssertion)vaPair.second).check(view, null);
                }
                viewAction.perform(uic, view);
            }
        };
    }

    public static ViewAction clearText() {
        return ViewActions.actionWithAssertions(new ReplaceTextAction(""));
    }

    public static ViewAction click(int inputDevice, int buttonState) {
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, inputDevice, buttonState));
    }

    public static ViewAction click() {
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, 0, 1));
    }

    public static ViewAction click(ViewAction rollbackAction) {
        Checks.checkNotNull((Object)rollbackAction);
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1, rollbackAction));
    }

    public static ViewAction swipeLeft() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_RIGHT, -0.083f, 0.0f), GeneralLocation.CENTER_LEFT, Press.FINGER));
    }

    public static ViewAction slowSwipeLeft() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.SLOW, GeneralLocation.translate(GeneralLocation.CENTER_RIGHT, -0.083f, 0.0f), GeneralLocation.CENTER_LEFT, Press.FINGER));
    }

    public static ViewAction swipeRight() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_LEFT, 0.083f, 0.0f), GeneralLocation.CENTER_RIGHT, Press.FINGER));
    }

    public static ViewAction swipeDown() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.TOP_CENTER, 0.0f, 0.083f), GeneralLocation.BOTTOM_CENTER, Press.FINGER));
    }

    public static ViewAction swipeUp() {
        return ViewActions.actionWithAssertions(new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.BOTTOM_CENTER, 0.0f, -0.083f), GeneralLocation.TOP_CENTER, Press.FINGER));
    }

    public static ViewAction closeSoftKeyboard() {
        return ViewActions.actionWithAssertions(new CloseKeyboardAction());
    }

    public static ViewAction pressImeActionButton() {
        return ViewActions.actionWithAssertions(new EditorAction());
    }

    public static ViewAction pressBack() {
        return ViewActions.actionWithAssertions(new PressBackAction(true));
    }

    public static ViewAction pressBackUnconditionally() {
        return ViewActions.actionWithAssertions(new PressBackAction(false));
    }

    public static ViewAction pressMenuKey() {
        return ViewActions.pressKey(82);
    }

    public static ViewAction pressKey(int keyCode) {
        return ViewActions.actionWithAssertions(new KeyEventAction(new EspressoKey.Builder().withKeyCode(keyCode).build()));
    }

    public static ViewAction pressKey(EspressoKey key) {
        return ViewActions.actionWithAssertions(new KeyEventAction(key));
    }

    public static ViewAction doubleClick() {
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.DOUBLE, GeneralLocation.CENTER, Press.FINGER, 0, 1));
    }

    public static ViewAction longClick() {
        return ViewActions.actionWithAssertions(new GeneralClickAction(Tap.LONG, GeneralLocation.CENTER, Press.FINGER, 0, 1));
    }

    public static ViewAction scrollTo() {
        return ViewActions.actionWithAssertions(new ScrollToAction());
    }

    public static ViewAction scrollTo(int isDisplayingAtLeastThreshold) {
        return ViewActions.actionWithAssertions(new ScrollToAction(isDisplayingAtLeastThreshold));
    }

    public static ViewAction scrollCompletelyTo() {
        return ViewActions.scrollTo(100);
    }

    public static ViewAction typeTextIntoFocusedView(String stringToBeTyped) {
        return ViewActions.actionWithAssertions(new TypeTextAction(stringToBeTyped, false));
    }

    public static ViewAction typeText(String stringToBeTyped) {
        return ViewActions.actionWithAssertions(new TypeTextAction(stringToBeTyped));
    }

    public static ViewAction replaceText(@NonNull String stringToBeSet) {
        return ViewActions.actionWithAssertions(new ReplaceTextAction(stringToBeSet));
    }

    public static ViewAction openLinkWithText(String linkText) {
        return ViewActions.openLinkWithText((Matcher<String>)Matchers.is((Object)linkText));
    }

    public static ViewAction openLinkWithText(Matcher<String> linkTextMatcher) {
        return ViewActions.openLink(linkTextMatcher, (Matcher<Uri>)Matchers.any(Uri.class));
    }

    public static ViewAction openLinkWithUri(String uri) {
        return ViewActions.openLinkWithUri((Matcher<Uri>)Matchers.is((Object)Uri.parse((String)uri)));
    }

    public static ViewAction openLinkWithUri(Matcher<Uri> uriMatcher) {
        return ViewActions.openLink((Matcher<String>)Matchers.any(String.class), uriMatcher);
    }

    public static ViewAction openLink(Matcher<String> linkTextMatcher, Matcher<Uri> uriMatcher) {
        Checks.checkNotNull(linkTextMatcher);
        Checks.checkNotNull(uriMatcher);
        return ViewActions.actionWithAssertions(new OpenLinkAction(linkTextMatcher, uriMatcher));
    }

    public static ViewAction repeatedlyUntil(ViewAction action, Matcher<View> desiredStateMatcher, int maxAttempts) {
        Checks.checkNotNull((Object)action);
        Checks.checkNotNull(desiredStateMatcher);
        return ViewActions.actionWithAssertions(new RepeatActionUntilViewState(action, desiredStateMatcher, maxAttempts));
    }

    public static ViewAction captureToBitmap(BitmapReceiver bitmapReceiver) {
        return new CaptureToBitmapAction(bitmapReceiver);
    }

    public static interface BitmapReceiver {
        public void onBitmapCaptured(Bitmap var1);
    }
}

