/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.util.Log;
import android.view.View;
import android.widget.SearchView;
import androidx.annotation.Nullable;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class TypeTextAction
implements ViewAction {
    private static final String TAG = TypeTextAction.class.getSimpleName();
    @RemoteMsgField(order=0)
    final String stringToBeTyped;
    @RemoteMsgField(order=1)
    final boolean tapToFocus;
    @Nullable
    final GeneralClickAction clickAction;

    public TypeTextAction(String stringToBeTyped) {
        this(stringToBeTyped, true, TypeTextAction.defaultClickAction());
    }

    @RemoteMsgConstructor
    public TypeTextAction(String stringToBeTyped, boolean tapToFocus) {
        this(stringToBeTyped, tapToFocus, null);
    }

    public TypeTextAction(String stringToBeTyped, boolean tapToFocus, GeneralClickAction clickAction) {
        Checks.checkNotNull((Object)stringToBeTyped);
        this.stringToBeTyped = stringToBeTyped;
        this.tapToFocus = tapToFocus;
        this.clickAction = clickAction;
    }

    @Override
    public Matcher<View> getConstraints() {
        Matcher matchers = Matchers.allOf((Matcher[])new Matcher[]{ViewMatchers.isDisplayed()});
        if (!this.tapToFocus) {
            matchers = Matchers.allOf((Matcher)matchers, ViewMatchers.hasFocus());
        }
        return Matchers.allOf((Matcher)matchers, (Matcher)Matchers.anyOf(ViewMatchers.supportsInputMethods(), ViewMatchers.isAssignableFrom(SearchView.class)));
    }

    @Override
    public void perform(UiController uiController, View view) {
        if (this.stringToBeTyped.length() == 0) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return;
        }
        if (this.tapToFocus) {
            if (this.clickAction == null) {
                TypeTextAction.defaultClickAction().perform(uiController, view);
            } else {
                this.clickAction.perform(uiController, view);
            }
            uiController.loopMainThreadUntilIdle();
        }
        try {
            if (!uiController.injectString(this.stringToBeTyped)) {
                Log.e((String)TAG, (String)("Failed to type text: " + this.stringToBeTyped));
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException("Failed to type text: " + this.stringToBeTyped)).build();
            }
        }
        catch (InjectEventSecurityException e) {
            Log.e((String)TAG, (String)("Failed to type text: " + this.stringToBeTyped));
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause((Throwable)((Object)e)).build();
        }
    }

    @Override
    public String getDescription() {
        return String.format(Locale.ROOT, "type text(%s)", this.stringToBeTyped);
    }

    private static GeneralClickAction defaultClickAction() {
        return new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1);
    }
}

