/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Tapper;
import androidx.test.internal.util.Checks;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public enum Tap implements Tapper
{
    SINGLE{

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] coordinates, float[] precision) {
            return this.sendTap(uiController, coordinates, precision, 0, 0);
        }

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
            Tapper.Status stat = Tap.sendSingleTap(uiController, coordinates, precision, inputDevice, buttonState);
            if (Tapper.Status.SUCCESS == stat) {
                long singlePressTimeout = (long)((float)ViewConfiguration.getTapTimeout() * 1.5f);
                uiController.loopMainThreadForAtLeast(singlePressTimeout);
            }
            return stat;
        }
    }
    ,
    LONG{

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] coordinates, float[] precision) {
            return this.sendTap(uiController, coordinates, precision, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tapper.Status sendTap(UiController uiController, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
            Checks.checkNotNull((Object)uiController);
            Checks.checkNotNull((Object)coordinates);
            Checks.checkNotNull((Object)precision);
            MotionEvent downEvent = MotionEvents.sendDown((UiController)uiController, (float[])coordinates, (float[])precision, (int)inputDevice, (int)buttonState).down;
            try {
                long longPressTimeout = (long)((float)ViewConfiguration.getLongPressTimeout() * 1.5f);
                uiController.loopMainThreadForAtLeast(longPressTimeout);
                if (!MotionEvents.sendUp(uiController, downEvent)) {
                    MotionEvents.sendCancel(uiController, downEvent);
                    Tapper.Status status = Tapper.Status.FAILURE;
                    return status;
                }
            }
            finally {
                downEvent.recycle();
                downEvent = null;
            }
            return Tapper.Status.SUCCESS;
        }
    }
    ,
    DOUBLE{

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] coordinates, float[] precision) {
            return this.sendTap(uiController, coordinates, precision, 0, 0);
        }

        @Override
        public Tapper.Status sendTap(UiController uiController, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
            Tapper.Status secondStat;
            Checks.checkNotNull((Object)uiController);
            Checks.checkNotNull((Object)coordinates);
            Checks.checkNotNull((Object)precision);
            Tapper.Status stat = Tap.sendSingleTap(uiController, coordinates, precision, inputDevice, buttonState);
            if (stat == Tapper.Status.FAILURE) {
                return Tapper.Status.FAILURE;
            }
            if (0 < DOUBLE_TAP_MIN_TIMEOUT) {
                uiController.loopMainThreadForAtLeast(DOUBLE_TAP_MIN_TIMEOUT);
            }
            if ((secondStat = Tap.sendSingleTap(uiController, coordinates, precision, inputDevice, buttonState)) == Tapper.Status.FAILURE) {
                return Tapper.Status.FAILURE;
            }
            if (secondStat == Tapper.Status.WARNING || stat == Tapper.Status.WARNING) {
                return Tapper.Status.WARNING;
            }
            return Tapper.Status.SUCCESS;
        }
    };

    private static final String TAG;
    private static final int DOUBLE_TAP_MIN_TIMEOUT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tapper.Status sendSingleTap(UiController uiController, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        Checks.checkNotNull((Object)uiController);
        Checks.checkNotNull((Object)coordinates);
        Checks.checkNotNull((Object)precision);
        MotionEvents.DownResultHolder res = MotionEvents.sendDown(uiController, coordinates, precision, inputDevice, buttonState);
        try {
            if (!MotionEvents.sendUp(uiController, res.down)) {
                Log.d((String)TAG, (String)"Injection of up event as part of the click failed. Send cancel event.");
                MotionEvents.sendCancel(uiController, res.down);
                Tapper.Status status = Tapper.Status.FAILURE;
                return status;
            }
        }
        finally {
            res.down.recycle();
        }
        return res.longPress ? Tapper.Status.WARNING : Tapper.Status.SUCCESS;
    }

    static {
        TAG = Tap.class.getSimpleName();
        int timeVal = 0;
        try {
            Method getDoubleTapMinTimeMethod = ViewConfiguration.class.getDeclaredMethod("getDoubleTapMinTime", new Class[0]);
            timeVal = (Integer)getDoubleTapMinTimeMethod.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            Log.w((String)TAG, (String)"Expected to find getDoubleTapMinTime", (Throwable)nsme);
        }
        catch (InvocationTargetException ite) {
            Log.w((String)TAG, (String)"Unable to query double tap min time!", (Throwable)ite);
        }
        catch (IllegalAccessException iae) {
            Log.w((String)TAG, (String)"Unable to query double tap min time!", (Throwable)iae);
        }
        DOUBLE_TAP_MIN_TIMEOUT = timeVal;
    }
}

