/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.MotionEvent;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.MotionEvents;
import androidx.test.espresso.action.Swiper;
import androidx.test.internal.util.Checks;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;

public enum Swipe implements Swiper
{
    FAST{

        @Override
        public Swiper.Status sendSwipe(UiController uiController, float[] startCoordinates, float[] endCoordinates, float[] precision) {
            return Swipe.sendLinearSwipe(uiController, startCoordinates, endCoordinates, precision, 150);
        }
    }
    ,
    SLOW{

        @Override
        public Swiper.Status sendSwipe(UiController uiController, float[] startCoordinates, float[] endCoordinates, float[] precision) {
            return Swipe.sendLinearSwipe(uiController, startCoordinates, endCoordinates, precision, 1500);
        }
    };

    private static final String TAG;
    private static final int SWIPE_EVENT_COUNT = 10;
    private static final int SWIPE_FAST_DURATION_MS = 150;
    private static final int SWIPE_SLOW_DURATION_MS = 1500;

    private static float[][] interpolate(float[] start, float[] end, int steps) {
        Swipe.checkElementIndex(1, start.length);
        Swipe.checkElementIndex(1, end.length);
        float[][] res = new float[steps][2];
        for (int i = 1; i < steps + 1; ++i) {
            res[i - 1][0] = start[0] + (end[0] - start[0]) * (float)i / ((float)steps + 2.0f);
            res[i - 1][1] = start[1] + (end[1] - start[1]) * (float)i / ((float)steps + 2.0f);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Swiper.Status sendLinearSwipe(UiController uiController, float[] startCoordinates, float[] endCoordinates, float[] precision, int duration) {
        Checks.checkNotNull((Object)uiController);
        Checks.checkNotNull((Object)startCoordinates);
        Checks.checkNotNull((Object)endCoordinates);
        Checks.checkNotNull((Object)precision);
        float[][] steps = Swipe.interpolate(startCoordinates, endCoordinates, 10);
        ArrayList<MotionEvent> events = new ArrayList<MotionEvent>();
        MotionEvent downEvent = MotionEvents.obtainDownEvent(startCoordinates, precision);
        events.add(downEvent);
        try {
            long intervalMS = duration / steps.length;
            long eventTime = downEvent.getDownTime();
            for (float[] step : steps) {
                events.add(MotionEvents.obtainMovement(downEvent, eventTime += intervalMS, step));
            }
            events.add(MotionEvents.obtainUpEvent(downEvent, eventTime += intervalMS, endCoordinates));
            uiController.injectMotionEventSequence(events);
        }
        catch (Exception e) {
            Swiper.Status status = Swiper.Status.FAILURE;
            return status;
        }
        finally {
            for (MotionEvent event : events) {
                event.recycle();
            }
        }
        return Swiper.Status.SUCCESS;
    }

    private static int checkElementIndex(int index, int size) {
        return Swipe.checkElementIndex(index, size, "index");
    }

    @CanIgnoreReturnValue
    private static int checkElementIndex(int index, int size, String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Swipe.badElementIndex(index, size, desc));
        }
        return index;
    }

    private static String badElementIndex(int index, int size, String desc) {
        if (index < 0) {
            return String.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return String.format("%s (%s) must be less than size (%s)", desc, index, size);
    }

    static {
        TAG = Swipe.class.getSimpleName();
    }
}

