/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.widget.HorizontalScrollView;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ScrollToAction
implements ViewAction {
    private static final String TAG = ScrollToAction.class.getSimpleName();
    private final int isDisplayingAtLeastThreshold;

    public ScrollToAction() {
        this(90);
    }

    public ScrollToAction(int isDisplayingAtLeastThreshold) {
        this.isDisplayingAtLeastThreshold = isDisplayingAtLeastThreshold;
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.allOf(ViewMatchers.withEffectiveVisibility(ViewMatchers.Visibility.VISIBLE), ViewMatchers.isDescendantOfA((Matcher<View>)Matchers.anyOf(ViewMatchers.isAssignableFrom(ScrollView.class), ViewMatchers.isAssignableFrom(HorizontalScrollView.class), ViewMatchers.isAssignableFrom(ListView.class), ScrollToAction.isAssignableFromClassName("androidx.core.widget.NestedScrollView"), ScrollToAction.isAssignableFromClassName("android.support.v7.widget.RecyclerView"), ScrollToAction.isAssignableFromClassName("androidx.recyclerview.widget.RecyclerView"))));
    }

    private static Matcher<View> isAssignableFromClassName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return ViewMatchers.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return new BaseMatcher<View>(){

                public void describeTo(Description description) {
                }

                public boolean matches(Object o) {
                    return false;
                }
            };
        }
    }

    @Override
    public void perform(UiController uiController, View view) {
        if (ViewMatchers.isDisplayingAtLeast(this.isDisplayingAtLeastThreshold).matches((Object)view)) {
            Log.i((String)TAG, (String)"View is already displayed. Returning.");
            return;
        }
        Rect rect = new Rect();
        view.getDrawingRect(rect);
        if (!view.requestRectangleOnScreen(rect, true)) {
            Log.w((String)TAG, (String)"Scrolling to view was requested, but none of the parents scrolled.");
        }
        uiController.loopMainThreadUntilIdle();
        if (!ViewMatchers.isDisplayingAtLeast(this.isDisplayingAtLeastThreshold).matches((Object)view)) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException("Scrolling to view was attempted, but the view is not displayed")).build();
        }
    }

    @Override
    public String getDescription() {
        return "scroll to";
    }
}

