/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class RepeatActionUntilViewState
implements ViewAction {
    private final ViewAction mAction;
    private final Matcher<View> mDesiredStateMatcher;
    private final int mMaxAttempts;

    protected RepeatActionUntilViewState(ViewAction action, Matcher<View> desiredStateMatcher, int maxAttempts) {
        Checks.checkNotNull((Object)action);
        Checks.checkNotNull(desiredStateMatcher);
        Checks.checkState((maxAttempts > 1 ? 1 : 0) != 0, (Object)"maxAttempts should be greater than 1");
        this.mAction = action;
        this.mDesiredStateMatcher = desiredStateMatcher;
        this.mMaxAttempts = maxAttempts;
    }

    @Override
    public Matcher<View> getConstraints() {
        return this.mAction.getConstraints();
    }

    @Override
    public String getDescription() {
        StringDescription stringDescription = new StringDescription();
        this.mDesiredStateMatcher.describeTo((Description)stringDescription);
        return String.format(Locale.ROOT, "%s until: %s", this.mAction.getDescription(), stringDescription);
    }

    @Override
    public void perform(UiController uiController, View view) {
        int noOfAttempts;
        for (noOfAttempts = 1; !this.mDesiredStateMatcher.matches((Object)view) && noOfAttempts <= this.mMaxAttempts; ++noOfAttempts) {
            this.mAction.perform(uiController, view);
            uiController.loopMainThreadUntilIdle();
        }
        if (noOfAttempts > this.mMaxAttempts) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "Failed to achieve view state after %d attempts", this.mMaxAttempts))).build();
        }
    }
}

