/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.net.Uri;
import android.text.Spanned;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class OpenLinkAction
implements ViewAction {
    private final Matcher<String> linkTextMatcher;
    private final Matcher<Uri> uriMatcher;

    public OpenLinkAction(Matcher<String> linkTextMatcher, Matcher<Uri> uriMatcher) {
        this.linkTextMatcher = (Matcher)Checks.checkNotNull(linkTextMatcher);
        this.uriMatcher = (Matcher)Checks.checkNotNull(uriMatcher);
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.isAssignableFrom(TextView.class), ViewMatchers.hasLinks());
    }

    @Override
    public String getDescription() {
        return String.format(Locale.ROOT, "open link with text %s and uri %s", this.linkTextMatcher, this.uriMatcher);
    }

    @Override
    public void perform(UiController uiController, View view) {
        TextView textView = (TextView)view;
        String allText = textView.getText().toString();
        URLSpan[] urls = textView.getUrls();
        Spanned spanned = (Spanned)textView.getText();
        ArrayList<String> allLinks = new ArrayList<String>();
        for (URLSpan url : urls) {
            int start = spanned.getSpanStart((Object)url);
            Checks.checkState((start != -1 ? 1 : 0) != 0, (Object)("Unable to get start of text associated with url: " + url));
            int end = spanned.getSpanEnd((Object)url);
            Checks.checkState((end != -1 ? 1 : 0) != 0, (Object)("Unable to get end of text associated with url: " + url));
            String linkText = allText.substring(start, end);
            allLinks.add(linkText);
            if (!this.linkTextMatcher.matches((Object)linkText) || !this.uriMatcher.matches((Object)Uri.parse((String)url.getURL()))) continue;
            url.onClick(view);
            return;
        }
        throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "Link with text '%s' and uri '%s' not found. List of links found in this view: %s\nList of uris: %s", this.linkTextMatcher, this.uriMatcher, allLinks, Arrays.asList(urls)))).build();
    }
}

