/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.internal.util.Checks;
import java.util.Locale;

public final class MotionEvents {
    private static final String TAG = MotionEvents.class.getSimpleName();
    @VisibleForTesting
    static final int MAX_CLICK_ATTEMPTS = 3;

    private MotionEvents() {
    }

    public static DownResultHolder sendDown(UiController uiController, float[] coordinates, float[] precision) {
        return MotionEvents.sendDown(uiController, coordinates, precision, 0, 1);
    }

    public static MotionEvent obtainDownEvent(float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        Checks.checkNotNull((Object)coordinates);
        Checks.checkNotNull((Object)precision);
        long downTime = SystemClock.uptimeMillis();
        return MotionEvents.obtain(downTime, downTime, 0, coordinates, precision[0], precision[1], inputDevice, buttonState);
    }

    public static MotionEvent obtainDownEvent(float[] coordinates, float[] precision) {
        return MotionEvents.obtainDownEvent(coordinates, precision, 0, 1);
    }

    public static DownResultHolder sendDown(UiController uiController, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        Checks.checkNotNull((Object)uiController);
        Checks.checkNotNull((Object)coordinates);
        Checks.checkNotNull((Object)precision);
        for (int retry = 0; retry < 3; ++retry) {
            try {
                long delayToBeTap;
                MotionEvent motionEvent = MotionEvents.obtainDownEvent(coordinates, precision, inputDevice, buttonState);
                long downTime = motionEvent.getDownTime();
                long isTapAt = downTime + (long)(ViewConfiguration.getTapTimeout() / 2);
                boolean injectEventSucceeded = uiController.injectMotionEvent(motionEvent);
                while ((delayToBeTap = isTapAt - SystemClock.uptimeMillis()) > 10L) {
                    uiController.loopMainThreadForAtLeast(delayToBeTap / 4L);
                }
                boolean longPress = false;
                if (SystemClock.uptimeMillis() > downTime + (long)ViewConfiguration.getLongPressTimeout()) {
                    longPress = true;
                    Log.w((String)TAG, (String)"Overslept and turned a tap into a long press");
                }
                if (injectEventSucceeded) {
                    return new DownResultHolder(motionEvent, longPress);
                }
                motionEvent.recycle();
                continue;
            }
            catch (InjectEventSecurityException e) {
                throw new PerformException.Builder().withActionDescription("Send down motion event").withViewDescription("unknown").withCause((Throwable)((Object)e)).build();
            }
        }
        throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "click (after %s attempts)", 3)).withViewDescription("unknown").build();
    }

    public static boolean sendUp(UiController uiController, MotionEvent downEvent) {
        return MotionEvents.sendUp(uiController, downEvent, new float[]{downEvent.getX(), downEvent.getY()});
    }

    public static MotionEvent obtainUpEvent(MotionEvent downEvent, float[] coordinates) {
        return MotionEvents.obtainUpEvent(downEvent, SystemClock.uptimeMillis(), coordinates);
    }

    public static MotionEvent obtainUpEvent(MotionEvent downEvent, long eventTime, float[] coordinates) {
        Checks.checkNotNull((Object)downEvent);
        Checks.checkNotNull((Object)coordinates);
        return MotionEvents.obtain(downEvent, eventTime, 1, coordinates);
    }

    public static boolean sendUp(UiController uiController, MotionEvent downEvent, float[] coordinates) {
        Checks.checkNotNull((Object)uiController);
        Checks.checkNotNull((Object)downEvent);
        Checks.checkNotNull((Object)coordinates);
        MotionEvent motionEvent = null;
        try {
            motionEvent = MotionEvents.obtainUpEvent(downEvent, coordinates);
            boolean injectEventSucceeded = uiController.injectMotionEvent(motionEvent);
            if (!injectEventSucceeded) {
                Log.e((String)TAG, (String)String.format(Locale.ROOT, "Injection of up event failed (corresponding down event: %s)", downEvent));
                boolean bl = false;
                return bl;
            }
        }
        catch (InjectEventSecurityException e) {
            throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "inject up event (corresponding down event: %s)", downEvent)).withViewDescription("unknown").withCause((Throwable)((Object)e)).build();
        }
        finally {
            if (null != motionEvent) {
                motionEvent.recycle();
            }
        }
        return true;
    }

    public static void sendCancel(UiController uiController, MotionEvent downEvent) {
        Checks.checkNotNull((Object)uiController);
        Checks.checkNotNull((Object)downEvent);
        MotionEvent motionEvent = null;
        try {
            float[] coordinates = new float[]{downEvent.getX(), downEvent.getY()};
            motionEvent = MotionEvents.obtain(downEvent, SystemClock.uptimeMillis(), 3, coordinates);
            boolean injectEventSucceeded = uiController.injectMotionEvent(motionEvent);
            if (!injectEventSucceeded) {
                Log.e((String)TAG, (String)String.format(Locale.ROOT, "Injection of cancel event failed (corresponding down event: %s)", downEvent));
                return;
            }
        }
        catch (InjectEventSecurityException e) {
            throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "inject cancel event (corresponding down event: %s)", downEvent)).withViewDescription("unknown").withCause((Throwable)((Object)e)).build();
        }
        finally {
            if (null != motionEvent) {
                motionEvent.recycle();
            }
        }
    }

    @NonNull
    public static MotionEvent obtainMovement(@NonNull MotionEvent downEvent, @NonNull float[] coordinates) {
        return MotionEvents.obtainMovement(downEvent, SystemClock.uptimeMillis(), coordinates);
    }

    @NonNull
    public static MotionEvent obtainMovement(@NonNull MotionEvent downEvent, long eventTime, @NonNull float[] coordinates) {
        Checks.checkNotNull((Object)downEvent);
        Checks.checkNotNull((Object)coordinates);
        return MotionEvents.obtain(downEvent, eventTime, 2, coordinates);
    }

    @Deprecated
    public static MotionEvent obtainMovement(long downTime, float[] coordinates) {
        return MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)2, (float)coordinates[0], (float)coordinates[1], (int)0);
    }

    @Deprecated
    public static MotionEvent obtainMovement(long downTime, long eventTime, float[] coordinates) {
        return MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)coordinates[0], (float)coordinates[1], (int)0);
    }

    public static boolean sendMovement(UiController uiController, MotionEvent downEvent, float[] coordinates) {
        Checks.checkNotNull((Object)uiController);
        Checks.checkNotNull((Object)downEvent);
        Checks.checkNotNull((Object)coordinates);
        MotionEvent motionEvent = null;
        try {
            motionEvent = MotionEvents.obtainMovement(downEvent, coordinates);
            boolean injectEventSucceeded = uiController.injectMotionEvent(motionEvent);
            if (!injectEventSucceeded) {
                Log.e((String)TAG, (String)String.format(Locale.ROOT, "Injection of motion event failed (corresponding down event: %s)", downEvent));
                boolean bl = false;
                return bl;
            }
        }
        catch (InjectEventSecurityException e) {
            throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "inject motion event (corresponding down event: %s)", downEvent)).withViewDescription("unknown").withCause((Throwable)((Object)e)).build();
        }
        finally {
            if (null != motionEvent) {
                motionEvent.recycle();
            }
        }
        return true;
    }

    private static MotionEvent obtain(MotionEvent downEvent, long eventTime, int action, float[] coordinates) {
        return MotionEvents.obtain(downEvent.getDownTime(), eventTime, action, coordinates, downEvent.getXPrecision(), downEvent.getYPrecision(), downEvent.getSource(), downEvent.getToolType(0), downEvent.getButtonState());
    }

    private static MotionEvent obtain(long downTime, long eventTime, int action, float[] coordinates, float xPrecision, float yPrecision, int source, int buttonState) {
        return MotionEvents.obtain(downTime, eventTime, action, coordinates, xPrecision, yPrecision, source, MotionEvents.mapInputDeviceToToolType(source), buttonState);
    }

    private static MotionEvent obtain(long downTime, long eventTime, int action, float[] coordinates, float xPrecision, float yPrecision, int source, int toolType, int buttonState) {
        MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
        MotionEvent.PointerProperties[] pointerProperties = MotionEvents.getPointerProperties(toolType);
        pointerCoords[0].clear();
        pointerCoords[0].x = coordinates[0];
        pointerCoords[0].y = coordinates[1];
        pointerCoords[0].pressure = 0.0f;
        pointerCoords[0].size = 1.0f;
        return MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)0, (int)buttonState, (float)xPrecision, (float)yPrecision, (int)0, (int)0, (int)source, (int)0);
    }

    private static MotionEvent.PointerProperties[] getPointerProperties(int toolType) {
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
        pointerProperties[0].clear();
        pointerProperties[0].id = 0;
        pointerProperties[0].toolType = toolType;
        return pointerProperties;
    }

    private static int mapInputDeviceToToolType(int inputDevice) {
        int toolType;
        switch (inputDevice) {
            case 8194: {
                toolType = 3;
                break;
            }
            case 16386: {
                toolType = 2;
                break;
            }
            case 4098: {
                toolType = 1;
                break;
            }
            default: {
                toolType = 0;
            }
        }
        return toolType;
    }

    public static class DownResultHolder {
        public final MotionEvent down;
        public final boolean longPress;

        DownResultHolder(MotionEvent down, boolean longPress) {
            this.down = down;
            this.longPress = longPress;
        }
    }
}

