/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.ActivityLifecycles;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Collection;
import java.util.Locale;
import org.hamcrest.Matcher;

class KeyEventActionBase
implements ViewAction {
    private static final String TAG = "KeyEventActionBase";
    public static final int BACK_ACTIVITY_TRANSITION_MILLIS_DELAY = 150;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_ATTEMPTS = 4;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_MILLIS_DELAY = 150;
    final EspressoKey espressoKey;

    KeyEventActionBase(EspressoKey espressoKey) {
        this.espressoKey = (EspressoKey)Checks.checkNotNull((Object)espressoKey);
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayed();
    }

    @Override
    public String getDescription() {
        return String.format(Locale.ROOT, "send %s key event", this.espressoKey);
    }

    @Override
    public void perform(UiController uiController, View view) {
        try {
            if (!this.sendKeyEvent(uiController)) {
                Log.e((String)TAG, (String)("Failed to inject espressoKey event: " + this.espressoKey));
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException("Failed to inject espressoKey event " + this.espressoKey)).build();
            }
        }
        catch (InjectEventSecurityException e) {
            Log.e((String)TAG, (String)("Failed to inject espressoKey event: " + this.espressoKey));
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause((Throwable)((Object)e)).build();
        }
    }

    private boolean sendKeyEvent(UiController controller) throws InjectEventSecurityException {
        int attempts;
        boolean injected = false;
        long eventTime = SystemClock.uptimeMillis();
        for (attempts = 0; !injected && attempts < 4; ++attempts) {
            injected = controller.injectKeyEvent(new KeyEvent(eventTime, eventTime, 0, this.espressoKey.getKeyCode(), 0, this.espressoKey.getMetaState()));
        }
        if (!injected) {
            return false;
        }
        injected = false;
        eventTime = SystemClock.uptimeMillis();
        for (attempts = 0; !injected && attempts < 4; ++attempts) {
            injected = controller.injectKeyEvent(new KeyEvent(eventTime, eventTime, 1, this.espressoKey.getKeyCode(), 0, this.espressoKey.getMetaState()));
        }
        return injected;
    }

    static Activity getCurrentActivity() {
        Collection resumedActivities = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        Checks.checkState((resumedActivities.size() == 1 ? 1 : 0) != 0, (Object)"There is not a single resumed Activity");
        return (Activity)resumedActivities.iterator().next();
    }

    static void waitForStageChangeInitialActivity(UiController controller, Activity initialActivity) {
        if (KeyEventActionBase.isActivityResumed(initialActivity)) {
            controller.loopMainThreadForAtLeast(150L);
            if (KeyEventActionBase.isActivityResumed(initialActivity)) {
                Log.i((String)TAG, (String)"Back was pressed but there was no Activity stage transition in 150ms. Pressing back may trigger an activity stage transition if the activity is finished as a result. However, the activity may handle the back behavior in any number of other ways internally as well, such as popping the fragment back stack, dismissing a dialog, otherwise manually transacting fragments, etc.");
            }
        }
    }

    private static boolean isActivityResumed(Activity activity) {
        return ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf(activity) == Stage.RESUMED;
    }

    static void waitForPendingForegroundActivities(UiController controller, boolean conditional) {
        ActivityLifecycleMonitor activityLifecycleMonitor = ActivityLifecycleMonitorRegistry.getInstance();
        boolean pendingForegroundActivities = false;
        for (int attempts = 0; attempts < 4; ++attempts) {
            controller.loopMainThreadUntilIdle();
            pendingForegroundActivities = ActivityLifecycles.hasTransitioningActivities(activityLifecycleMonitor);
            if (!pendingForegroundActivities) break;
            controller.loopMainThreadForAtLeast(150L);
        }
        if (!ActivityLifecycles.hasForegroundActivities(activityLifecycleMonitor)) {
            if (conditional) {
                throw new NoActivityResumedException("Pressed back and killed the app");
            }
            Log.w((String)TAG, (String)"Pressed back and hopped to a different process or potentially killed the app");
        }
        if (pendingForegroundActivities) {
            Log.w((String)TAG, (String)"Back was pressed and left the application in an inconsistent state even after 600ms.");
        }
    }
}

