/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import android.view.ViewConfiguration;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class GeneralSwipeAction
implements ViewAction {
    private static final int MAX_TRIES = 3;
    private static final int VIEW_DISPLAY_PERCENTAGE = 90;
    final CoordinatesProvider startCoordinatesProvider;
    final CoordinatesProvider endCoordinatesProvider;
    final Swiper swiper;
    final PrecisionDescriber precisionDescriber;

    public GeneralSwipeAction(Swiper swiper, CoordinatesProvider startCoordinatesProvider, CoordinatesProvider endCoordinatesProvider, PrecisionDescriber precisionDescriber) {
        this.swiper = swiper;
        this.startCoordinatesProvider = startCoordinatesProvider;
        this.endCoordinatesProvider = endCoordinatesProvider;
        this.precisionDescriber = precisionDescriber;
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayingAtLeast(90);
    }

    @Override
    public void perform(UiController uiController, View view) {
        float[] startCoordinates = this.startCoordinatesProvider.calculateCoordinates(view);
        float[] endCoordinates = this.endCoordinatesProvider.calculateCoordinates(view);
        float[] precision = this.precisionDescriber.describePrecision();
        Swiper.Status status = Swiper.Status.FAILURE;
        for (int tries = 0; tries < 3 && status != Swiper.Status.SUCCESS; ++tries) {
            try {
                status = this.swiper.sendSwipe(uiController, startCoordinates, endCoordinates, precision);
            }
            catch (RuntimeException re) {
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(re).build();
            }
            int duration = ViewConfiguration.getPressedStateDuration();
            if (duration <= 0) continue;
            uiController.loopMainThreadForAtLeast(duration);
        }
        if (status == Swiper.Status.FAILURE) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "Couldn't swipe from: %s,%s to: %s,%s precision: %s, %s . Swiper: %s start coordinate provider: %s precision describer: %s. Tried %s times", Float.valueOf(startCoordinates[0]), Float.valueOf(startCoordinates[1]), Float.valueOf(endCoordinates[0]), Float.valueOf(endCoordinates[1]), Float.valueOf(precision[0]), Float.valueOf(precision[1]), this.swiper, this.startCoordinatesProvider, this.precisionDescriber, 3))).build();
        }
    }

    @Override
    public String getDescription() {
        return this.swiper.toString().toLowerCase() + " swipe";
    }
}

