/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.TranslatedCoordinatesProvider;

public enum GeneralLocation implements CoordinatesProvider
{
    TOP_LEFT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.BEGIN);
        }
    }
    ,
    TOP_CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.MIDDLE);
        }
    }
    ,
    TOP_RIGHT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.BEGIN, Position.END);
        }
    }
    ,
    CENTER_LEFT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.BEGIN);
        }
    }
    ,
    CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.MIDDLE);
        }
    }
    ,
    CENTER_RIGHT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.MIDDLE, Position.END);
        }
    }
    ,
    BOTTOM_LEFT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.END, Position.BEGIN);
        }
    }
    ,
    BOTTOM_CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.END, Position.MIDDLE);
        }
    }
    ,
    BOTTOM_RIGHT{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinates(view, Position.END, Position.END);
        }
    }
    ,
    VISIBLE_CENTER{

        @Override
        public float[] calculateCoordinates(View view) {
            return GeneralLocation.getCoordinatesOfVisiblePart(view, Position.MIDDLE, Position.MIDDLE);
        }
    };


    @NonNull
    public static CoordinatesProvider translate(@NonNull CoordinatesProvider coords, float dx, float dy) {
        return new TranslatedCoordinatesProvider(coords, dx, dy);
    }

    private static float[] getCoordinates(View view, Position vertical, Position horizontal) {
        int[] xy = new int[2];
        view.getLocationOnScreen(xy);
        float x = horizontal.getPosition(xy[0], view.getWidth());
        float y = vertical.getPosition(xy[1], view.getHeight());
        float[] coordinates = new float[]{x, y};
        return coordinates;
    }

    private static float[] getCoordinatesOfVisiblePart(View view, Position vertical, Position horizontal) {
        int[] xy = new int[2];
        view.getLocationOnScreen(xy);
        Rect visibleParts = new Rect();
        view.getGlobalVisibleRect(visibleParts);
        float x = horizontal.getPosition(xy[0], visibleParts.width());
        float y = vertical.getPosition(xy[1], visibleParts.height());
        float[] coordinates = new float[]{x, y};
        return coordinates;
    }

    private static enum Position {
        BEGIN{

            @Override
            public float getPosition(int viewPos, int viewLength) {
                return viewPos;
            }
        }
        ,
        MIDDLE{

            @Override
            public float getPosition(int viewPos, int viewLength) {
                return (float)viewPos + (float)(viewLength - 1) / 2.0f;
            }
        }
        ,
        END{

            @Override
            public float getPosition(int viewPos, int viewLength) {
                return viewPos + viewLength - 1;
            }
        };


        abstract float getPosition(int var1, int var2);
    }
}

