/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.Tapper;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class GeneralClickAction
implements ViewAction {
    private static final String TAG = "GeneralClickAction";
    final CoordinatesProvider coordinatesProvider;
    final Tapper tapper;
    final PrecisionDescriber precisionDescriber;
    @Nullable
    private final ViewAction rollbackAction;
    private final int inputDevice;
    private final int buttonState;

    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber) {
        this(tapper, coordinatesProvider, precisionDescriber, 0, 0, null);
    }

    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int inputDevice, int buttonState) {
        this(tapper, coordinatesProvider, precisionDescriber, inputDevice, buttonState, null);
    }

    @Deprecated
    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, ViewAction rollbackAction) {
        this(tapper, coordinatesProvider, precisionDescriber, 0, 0, rollbackAction);
    }

    public GeneralClickAction(Tapper tapper, CoordinatesProvider coordinatesProvider, PrecisionDescriber precisionDescriber, int inputDevice, int buttonState, ViewAction rollbackAction) {
        this.coordinatesProvider = coordinatesProvider;
        this.tapper = tapper;
        this.precisionDescriber = precisionDescriber;
        this.inputDevice = inputDevice;
        this.buttonState = buttonState;
        this.rollbackAction = rollbackAction;
    }

    @Override
    public Matcher<View> getConstraints() {
        Matcher<View> standardConstraint = ViewMatchers.isDisplayingAtLeast(90);
        if (this.rollbackAction != null) {
            return Matchers.allOf(standardConstraint, this.rollbackAction.getConstraints());
        }
        return standardConstraint;
    }

    @Override
    public void perform(UiController uiController, View view) {
        int loopCount;
        float[] coordinates = this.coordinatesProvider.calculateCoordinates(view);
        float[] precision = this.precisionDescriber.describePrecision();
        Tapper.Status status = Tapper.Status.FAILURE;
        for (loopCount = 0; status != Tapper.Status.SUCCESS && loopCount < 3; ++loopCount) {
            try {
                status = this.tapper.sendTap(uiController, coordinates, precision, this.inputDevice, this.buttonState);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("perform: " + String.format(Locale.ROOT, "%s - At Coordinates: %d, %d and precision: %d, %d", this.getDescription(), (int)coordinates[0], (int)coordinates[1], (int)precision[0], (int)precision[1])));
                }
            }
            catch (RuntimeException re) {
                throw new PerformException.Builder().withActionDescription(String.format(Locale.ROOT, "%s - At Coordinates: %d, %d and precision: %d, %d", this.getDescription(), (int)coordinates[0], (int)coordinates[1], (int)precision[0], (int)precision[1])).withViewDescription(HumanReadables.describe(view)).withCause(re).build();
            }
            int duration = ViewConfiguration.getPressedStateDuration();
            if (duration > 0) {
                uiController.loopMainThreadForAtLeast(duration);
            }
            if (status != Tapper.Status.WARNING) continue;
            if (this.rollbackAction == null) break;
            this.rollbackAction.perform(uiController, view);
        }
        if (status == Tapper.Status.FAILURE) {
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "Couldn't click at: %s,%s precision: %s, %s . Tapper: %s coordinate provider: %s precision describer: %s. Tried %s times. With Rollback? %s", Float.valueOf(coordinates[0]), Float.valueOf(coordinates[1]), Float.valueOf(precision[0]), Float.valueOf(precision[1]), this.tapper, this.coordinatesProvider, this.precisionDescriber, loopCount, this.rollbackAction != null))).build();
        }
        if (this.tapper == Tap.SINGLE && view instanceof WebView) {
            uiController.loopMainThreadForAtLeast(ViewConfiguration.getDoubleTapTimeout());
        }
    }

    @Override
    public String getDescription() {
        return this.tapper.toString().toLowerCase() + " click";
    }
}

