/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.KeyEvent;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.internal.util.Checks;
import java.util.Locale;

public final class EspressoKey {
    @RemoteMsgField(order=0)
    private final int keyCode;
    @RemoteMsgField(order=1)
    private final int metaState;

    private EspressoKey(Builder builder) {
        this(builder.builderKeyCode, builder.getMetaState());
    }

    @RemoteMsgConstructor
    EspressoKey(int keyCode, int metaState) {
        this.keyCode = keyCode;
        this.metaState = metaState;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getMetaState() {
        return this.metaState;
    }

    public String toString() {
        return String.format(Locale.ROOT, "keyCode: %s, metaState: %s", this.keyCode, this.metaState);
    }

    public static class Builder {
        private int builderKeyCode = -1;
        private boolean isShiftPressed;
        private boolean isAltPressed;
        private boolean isCtrlPressed;

        public Builder withKeyCode(int keyCode) {
            this.builderKeyCode = keyCode;
            return this;
        }

        public Builder withShiftPressed(boolean shiftPressed) {
            this.isShiftPressed = shiftPressed;
            return this;
        }

        public Builder withCtrlPressed(boolean ctrlPressed) {
            this.isCtrlPressed = ctrlPressed;
            return this;
        }

        public Builder withAltPressed(boolean altPressed) {
            this.isAltPressed = altPressed;
            return this;
        }

        private int getMetaState() {
            int metaState = 0;
            if (this.isShiftPressed) {
                metaState |= 1;
            }
            if (this.isAltPressed) {
                metaState |= 2;
            }
            if (this.isCtrlPressed) {
                metaState |= 0x1000;
            }
            return metaState;
        }

        public EspressoKey build() {
            Checks.checkState((this.builderKeyCode > 0 && this.builderKeyCode < KeyEvent.getMaxKeyCode() ? 1 : 0) != 0, (String)"Invalid key code: %s", (Object[])new Object[]{this.builderKeyCode});
            return new EspressoKey(this);
        }
    }
}

