/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class CloseKeyboardAction
implements ViewAction {
    private static final int NUM_RETRIES = 3;
    private static final String TAG = CloseKeyboardAction.class.getSimpleName();

    @RemoteMsgConstructor
    public CloseKeyboardAction() {
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.any(View.class);
    }

    @Override
    public void perform(UiController uiController, View view) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.tryToCloseKeyboard(view, uiController);
                return;
            }
            catch (TimeoutException te) {
                Log.w((String)TAG, (String)"Caught timeout exception. Retrying.");
                if (i != 2) continue;
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(te).build();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToCloseKeyboard(View view, UiController uiController) throws TimeoutException {
        CloseKeyboardIdlingResult idlingResult;
        block7: {
            block6: {
                InputMethodManager imm = (InputMethodManager)CloseKeyboardAction.getRootActivity(uiController).getSystemService("input_method");
                idlingResult = new CloseKeyboardIdlingResult(new Handler(Looper.getMainLooper()));
                IdlingRegistry.getInstance().register(new IdlingResource[]{idlingResult});
                try {
                    if (imm.hideSoftInputFromWindow(view.getWindowToken(), 0, (ResultReceiver)idlingResult)) break block6;
                    Log.w((String)TAG, (String)"Attempting to close soft keyboard, while it is not shown.");
                }
                catch (Throwable throwable) {
                    IdlingRegistry.getInstance().unregister(new IdlingResource[]{idlingResult});
                    throw throwable;
                }
                IdlingRegistry.getInstance().unregister(new IdlingResource[]{idlingResult});
                return;
            }
            if (!idlingResult.receivedResult) break block7;
            IdlingRegistry.getInstance().unregister(new IdlingResource[]{idlingResult});
            return;
        }
        idlingResult.scheduleTimeout(2000L);
        uiController.loopMainThreadUntilIdle();
        if (idlingResult.timedOut) {
            throw new TimeoutException("Wait on operation result timed out.");
        }
        IdlingRegistry.getInstance().unregister(new IdlingResource[]{idlingResult});
        if (idlingResult.result != 1 && idlingResult.result != 3) {
            String error = "Attempt to close the soft keyboard did not result in soft keyboard to be hidden. resultCode = " + idlingResult.result;
            Log.e((String)TAG, (String)error);
            throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(error)).build();
        }
    }

    private static Activity getRootActivity(UiController uiController) {
        Collection resumedActivities = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        if (resumedActivities.isEmpty()) {
            uiController.loopMainThreadUntilIdle();
            resumedActivities = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        }
        Checks.checkState((resumedActivities.size() == 1 ? 1 : 0) != 0, (Object)"More than one activity is in RESUMED stage. There may have been an error during the activity creation/startup process, please check your logs.");
        return (Activity)resumedActivities.iterator().next();
    }

    @Override
    public String getDescription() {
        return "close keyboard";
    }

    private static class CloseKeyboardIdlingResult
    extends ResultReceiver
    implements IdlingResource {
        private IdlingResource.ResourceCallback resourceCallback;
        private boolean receivedResult = false;
        private int result = -1;
        private boolean timedOut = false;
        private boolean idle = false;
        private final Handler handler;

        private CloseKeyboardIdlingResult(Handler h) {
            super(h);
            this.handler = h;
        }

        private void scheduleTimeout(long millis) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!receivedResult) {
                        timedOut = true;
                        if (null != resourceCallback) {
                            resourceCallback.onTransitionToIdle();
                        }
                    }
                }
            }, millis);
        }

        private void notifyEspresso(long millis) {
            Checks.checkState((boolean)this.receivedResult);
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    idle = true;
                    if (null != resourceCallback) {
                        resourceCallback.onTransitionToIdle();
                    }
                }
            }, millis);
        }

        protected void onReceiveResult(int resultCode, Bundle resultData) {
            this.result = resultCode;
            this.receivedResult = true;
            this.notifyEspresso(300L);
        }

        public String getName() {
            return "CloseKeyboardIdlingResource";
        }

        public boolean isIdleNow() {
            return this.idle || this.timedOut;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback callback) {
            this.resourceCallback = callback;
        }
    }
}

