/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.test.core.internal.os.HandlerExecutor;
import androidx.test.core.view.ViewCapture;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.RunnableIdlingResource;
import androidx.test.espresso.action.ViewActions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Landroidx/test/espresso/action/CaptureToBitmapAction;", "Landroidx/test/espresso/ViewAction;", "bitmapReceiver", "Landroidx/test/espresso/action/ViewActions$BitmapReceiver;", "(Landroidx/test/espresso/action/ViewActions$BitmapReceiver;)V", "getBitmapReceiver", "()Landroidx/test/espresso/action/ViewActions$BitmapReceiver;", "getConstraints", "Lorg/hamcrest/Matcher;", "Landroid/view/View;", "getDescription", "", "perform", "", "uiController", "Landroidx/test/espresso/UiController;", "view", "espresso_core_java_androidx_test_espresso_action-action_kt"})
public final class CaptureToBitmapAction
implements ViewAction {
    @NotNull
    private final ViewActions.BitmapReceiver bitmapReceiver;

    public CaptureToBitmapAction(@NotNull ViewActions.BitmapReceiver bitmapReceiver) {
        Intrinsics.checkNotNullParameter((Object)bitmapReceiver, (String)"bitmapReceiver");
        this.bitmapReceiver = bitmapReceiver;
    }

    @NotNull
    public final ViewActions.BitmapReceiver getBitmapReceiver() {
        return this.bitmapReceiver;
    }

    @Override
    @NotNull
    public Matcher<View> getConstraints() {
        Matcher matcher = Matchers.any(View.class);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"any(View::class.java)");
        return matcher;
    }

    @Override
    @NotNull
    public String getDescription() {
        Locale locale = Locale.ROOT;
        String string = "capture view to Bitmap";
        Object[] objectArray = new Object[]{};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        return string2;
    }

    @Override
    public void perform(@NotNull UiController uiController, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)uiController, (String)"uiController");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        uiController.loopMainThreadUntilIdle();
        RunnableIdlingResource captureIdlingResource = new RunnableIdlingResource();
        IdlingResource[] idlingResourceArray = new IdlingResource[]{captureIdlingResource};
        IdlingRegistry.getInstance().register(idlingResourceArray);
        ListenableFuture futureBitmap = ViewCapture.captureToBitmapAsync$default((View)view, null, (int)1, null);
        HandlerExecutor mainExecutor = new HandlerExecutor(new Handler(Looper.getMainLooper()));
        futureBitmap.addListener((Runnable)captureIdlingResource, (Executor)mainExecutor);
        uiController.loopMainThreadUntilIdle();
        IdlingResource[] idlingResourceArray2 = new IdlingResource[]{captureIdlingResource};
        IdlingRegistry.getInstance().unregister(idlingResourceArray2);
        Bitmap destBitmap = (Bitmap)futureBitmap.get(1L, TimeUnit.MILLISECONDS);
        this.bitmapReceiver.onBitmapCaptured(destBitmap);
    }
}

