/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.database.Cursor;
import android.util.Log;
import android.view.View;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.AdapterViewFlipper;
import androidx.annotation.Nullable;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;

public final class AdapterViewProtocols {
    private static final int FULLY_RENDERED_PERCENTAGE_CUTOFF = 90;
    private static final AdapterViewProtocol STANDARD_PROTOCOL = new StandardAdapterViewProtocol();

    private AdapterViewProtocols() {
    }

    public static AdapterViewProtocol standardProtocol() {
        return STANDARD_PROTOCOL;
    }

    private static final class StandardAdapterViewProtocol
    implements AdapterViewProtocol {
        private static final String TAG = "StdAdapterViewProtocol";

        @Override
        public Iterable<AdapterViewProtocol.AdaptedData> getDataInAdapterView(AdapterView<? extends Adapter> adapterView) {
            ArrayList<AdapterViewProtocol.AdaptedData> datas = new ArrayList<AdapterViewProtocol.AdaptedData>();
            int i = 0;
            while (i < adapterView.getCount()) {
                int position = i++;
                Object dataAtPosition = adapterView.getItemAtPosition(position);
                datas.add(new AdapterViewProtocol.AdaptedData.Builder().withDataFunction(new StandardDataFunction(dataAtPosition, position)).withOpaqueToken(position).build());
            }
            return datas;
        }

        @Override
        @Deprecated
        public EspressoOptional<AdapterViewProtocol.AdaptedData> getDataRenderedByView(AdapterView<? extends Adapter> adapterView, View descendantView) {
            return EspressoOptional.of(this.getDataRenderedByView2(adapterView, descendantView));
        }

        @Override
        @Nullable
        public AdapterViewProtocol.AdaptedData getDataRenderedByView2(AdapterView<? extends Adapter> adapterView, View descendantView) {
            int position;
            if (adapterView == descendantView.getParent() && (position = adapterView.getPositionForView(descendantView)) != -1) {
                return new AdapterViewProtocol.AdaptedData.Builder().withDataFunction(new StandardDataFunction(adapterView.getItemAtPosition(position), position)).withOpaqueToken(position).build();
            }
            return null;
        }

        @Override
        public void makeDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData data) {
            Checks.checkArgument((boolean)(data.opaqueToken instanceof Integer), (String)"Not my data: %s", (Object[])new Object[]{data});
            int position = (Integer)data.opaqueToken;
            boolean moved = false;
            if (adapterView instanceof AbsListView) {
                ((AbsListView)adapterView).smoothScrollToPositionFromTop(position, adapterView.getPaddingTop(), 0);
                moved = true;
            }
            if (adapterView instanceof AdapterViewAnimator) {
                if (adapterView instanceof AdapterViewFlipper) {
                    ((AdapterViewFlipper)adapterView).stopFlipping();
                }
                ((AdapterViewAnimator)adapterView).setDisplayedChild(position);
                moved = true;
            }
            if (!moved) {
                adapterView.setSelection(position);
            }
        }

        @Override
        public boolean isDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData adaptedData) {
            Checks.checkArgument((boolean)(adaptedData.opaqueToken instanceof Integer), (String)"Not my data: %s", (Object[])new Object[]{adaptedData});
            int dataPosition = (Integer)adaptedData.opaqueToken;
            boolean inView = false;
            if (dataPosition >= adapterView.getFirstVisiblePosition() && dataPosition <= adapterView.getLastVisiblePosition()) {
                inView = adapterView.getFirstVisiblePosition() == adapterView.getLastVisiblePosition() ? true : this.isElementFullyRendered(adapterView, dataPosition - adapterView.getFirstVisiblePosition());
            }
            if (inView) {
                adapterView.setSelection(dataPosition);
            }
            return inView;
        }

        private boolean isElementFullyRendered(AdapterView<? extends Adapter> adapterView, int childAt) {
            View element = adapterView.getChildAt(childAt);
            return ViewMatchers.isDisplayingAtLeast(90).matches((Object)element);
        }

        private static final class StandardDataFunction
        implements AdapterViewProtocol.DataFunction {
            private final Object dataAtPosition;
            private final int position;

            private StandardDataFunction(Object dataAtPosition, int position) {
                Checks.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
                this.dataAtPosition = dataAtPosition;
                this.position = position;
            }

            @Override
            public Object getData() {
                if (this.dataAtPosition instanceof Cursor && !((Cursor)this.dataAtPosition).moveToPosition(this.position)) {
                    Log.e((String)StandardAdapterViewProtocol.TAG, (String)("Cannot move cursor to position: " + this.position));
                }
                return this.dataAtPosition;
            }
        }
    }
}

