/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.database.Cursor;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.annotation.Nullable;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import java.util.Locale;

public interface AdapterViewProtocol {
    public Iterable<AdaptedData> getDataInAdapterView(AdapterView<? extends Adapter> var1);

    @Deprecated
    public EspressoOptional<AdaptedData> getDataRenderedByView(AdapterView<? extends Adapter> var1, View var2);

    @Nullable
    default public AdaptedData getDataRenderedByView2(AdapterView<? extends Adapter> adapterView, View descendantView) {
        return this.getDataRenderedByView(adapterView, descendantView).get();
    }

    public void makeDataRenderedWithinAdapterView(AdapterView<? extends Adapter> var1, AdaptedData var2);

    public boolean isDataRenderedWithinAdapterView(AdapterView<? extends Adapter> var1, AdaptedData var2);

    public static class AdaptedData {
        @Deprecated
        @Nullable
        public final Object data;
        public final Object opaqueToken;
        private final DataFunction dataFunction;

        public Object getData() {
            return this.dataFunction.getData();
        }

        public String toString() {
            String itsClass;
            Object myData = this.getData();
            String string = itsClass = null == myData ? "null" : myData.getClass().getName();
            if (myData instanceof Cursor) {
                myData = HumanReadables.describe((Cursor)myData);
            }
            return String.format(Locale.ROOT, "Data: %s (class: %s) token: %s", myData, itsClass, this.opaqueToken);
        }

        private AdaptedData(Object data, Object opaqueToken, DataFunction dataFunction) {
            this.data = data;
            this.opaqueToken = Checks.checkNotNull((Object)opaqueToken);
            this.dataFunction = (DataFunction)Checks.checkNotNull((Object)dataFunction);
        }

        public static class Builder {
            private Object data;
            private Object opaqueToken;
            private DataFunction dataFunction;

            public Builder withDataFunction(@Nullable DataFunction dataFunction) {
                this.dataFunction = dataFunction;
                return this;
            }

            public Builder withData(@Nullable Object data) {
                this.data = data;
                return this;
            }

            public Builder withOpaqueToken(@Nullable Object opaqueToken) {
                this.opaqueToken = opaqueToken;
                return this;
            }

            public AdaptedData build() {
                if (null != this.dataFunction) {
                    this.data = this.dataFunction.getData();
                } else {
                    this.dataFunction = new DataFunction(){

                        @Override
                        public Object getData() {
                            return data;
                        }
                    };
                }
                return new AdaptedData(this.data, this.opaqueToken, this.dataFunction);
            }
        }
    }

    public static interface DataFunction {
        public Object getData();
    }
}

