/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.annotation.Nullable;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import java.util.ArrayList;
import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class AdapterDataLoaderAction
implements ViewAction {
    final Matcher<? extends Object> dataToLoadMatcher;
    @Nullable
    final Integer atPosition;
    final AdapterViewProtocol adapterViewProtocol;
    private AdapterViewProtocol.AdaptedData adaptedData;
    private boolean performed = false;
    private final Object dataLock = new Object();

    @Deprecated
    public AdapterDataLoaderAction(Matcher<? extends Object> dataToLoadMatcher, EspressoOptional<Integer> atPosition, AdapterViewProtocol adapterViewProtocol) {
        this(dataToLoadMatcher, atPosition.get(), adapterViewProtocol);
    }

    public AdapterDataLoaderAction(Matcher<? extends Object> dataToLoadMatcher, @Nullable Integer atPosition, AdapterViewProtocol adapterViewProtocol) {
        this.dataToLoadMatcher = (Matcher)Checks.checkNotNull(dataToLoadMatcher);
        this.atPosition = atPosition;
        this.adapterViewProtocol = (AdapterViewProtocol)Checks.checkNotNull((Object)adapterViewProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdapterViewProtocol.AdaptedData getAdaptedData() {
        Object object = this.dataLock;
        synchronized (object) {
            Checks.checkState((boolean)this.performed, (Object)"perform hasn't been called yet!");
            return this.adaptedData;
        }
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.allOf(ViewMatchers.isAssignableFrom(AdapterView.class), ViewMatchers.isDisplayed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(UiController uiController, View view) {
        Object dataMatcherDescription;
        AdapterView adapterView = (AdapterView)view;
        ArrayList<AdapterViewProtocol.AdaptedData> matchedDataItems = new ArrayList<AdapterViewProtocol.AdaptedData>();
        for (AdapterViewProtocol.AdaptedData data : this.adapterViewProtocol.getDataInAdapterView((AdapterView<? extends Adapter>)adapterView)) {
            if (!this.dataToLoadMatcher.matches(data.getData())) continue;
            matchedDataItems.add(data);
        }
        if (matchedDataItems.size() == 0) {
            dataMatcherDescription = new StringDescription();
            this.dataToLoadMatcher.describeTo((Description)dataMatcherDescription);
            if (matchedDataItems.isEmpty()) {
                dataMatcherDescription.appendText(" contained values: ");
                dataMatcherDescription.appendValue(this.adapterViewProtocol.getDataInAdapterView((AdapterView<? extends Adapter>)adapterView));
                throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException("No data found matching: " + dataMatcherDescription)).build();
            }
        }
        dataMatcherDescription = this.dataLock;
        synchronized (dataMatcherDescription) {
            Checks.checkState((!this.performed ? 1 : 0) != 0, (Object)"perform called 2x!");
            this.performed = true;
            if (this.atPosition != null) {
                int matchedDataItemsSize = matchedDataItems.size() - 1;
                if (this.atPosition > matchedDataItemsSize) {
                    throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException(String.format(Locale.ROOT, "There are only %d elements that matched but requested %d element.", matchedDataItemsSize, this.atPosition))).build();
                }
                this.adaptedData = (AdapterViewProtocol.AdaptedData)matchedDataItems.get(this.atPosition);
            } else {
                if (matchedDataItems.size() != 1) {
                    StringDescription dataMatcherDescription2 = new StringDescription();
                    this.dataToLoadMatcher.describeTo((Description)dataMatcherDescription2);
                    throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe(view)).withCause(new RuntimeException("Multiple data elements matched: " + dataMatcherDescription2 + ". Elements: " + matchedDataItems)).build();
                }
                this.adaptedData = (AdapterViewProtocol.AdaptedData)matchedDataItems.get(0);
            }
        }
        int requestCount = 0;
        while (!this.adapterViewProtocol.isDataRenderedWithinAdapterView((AdapterView<? extends Adapter>)adapterView, this.adaptedData)) {
            if (requestCount > 1) {
                if (requestCount % 50 == 0) {
                    adapterView.invalidate();
                    this.adapterViewProtocol.makeDataRenderedWithinAdapterView((AdapterView<? extends Adapter>)adapterView, this.adaptedData);
                }
            } else {
                this.adapterViewProtocol.makeDataRenderedWithinAdapterView((AdapterView<? extends Adapter>)adapterView, this.adaptedData);
            }
            uiController.loopMainThreadForAtLeast(100L);
            ++requestCount;
        }
    }

    @Override
    public String getDescription() {
        return "load adapter data";
    }
}

