/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.test.espresso.Root;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.base.PlatformTestStorageModule;
import androidx.test.espresso.base.RootViewPicker;
import androidx.test.espresso.base.ViewFinderImpl;
import androidx.test.espresso.core.internal.deps.dagger.Module;
import androidx.test.espresso.core.internal.deps.dagger.Provides;
import androidx.test.espresso.internal.data.TestFlowVisualizer;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.remote.RemoteInteractionRegistry;
import androidx.test.internal.util.Checks;
import androidx.test.platform.io.PlatformTestStorage;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;

@Module(includes={PlatformTestStorageModule.class})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class ViewInteractionModule {
    private final Matcher<View> viewMatcher;
    private final AtomicReference<Matcher<Root>> rootMatcher = new AtomicReference<Matcher<Root>>(RootMatchers.DEFAULT);
    private final AtomicReference<Boolean> needsActivity = new AtomicReference<Boolean>(true);

    ViewInteractionModule(Matcher<View> viewMatcher) {
        this.viewMatcher = (Matcher)Checks.checkNotNull(viewMatcher);
    }

    @Provides
    RemoteInteraction provideRemoteInteraction() {
        return RemoteInteractionRegistry.getInstance();
    }

    @Provides
    AtomicReference<Boolean> provideNeedsActivity() {
        return this.needsActivity;
    }

    @Provides
    AtomicReference<Matcher<Root>> provideRootMatcher() {
        return this.rootMatcher;
    }

    @Provides
    Matcher<View> provideViewMatcher() {
        return this.viewMatcher;
    }

    @Provides
    ViewFinder provideViewFinder(ViewFinderImpl impl) {
        return impl;
    }

    @Provides
    public View provideRootView(RootViewPicker rootViewPicker) {
        return rootViewPicker.get();
    }

    @Provides
    TestFlowVisualizer provideTestFlowVisualizer(PlatformTestStorage platformTestStorage) {
        return TestFlowVisualizer.getInstance(platformTestStorage);
    }
}

