/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.InteractionResultsHandler;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.internal.data.TestFlowVisualizer;
import androidx.test.espresso.internal.data.model.ActionData;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.remote.IInteractionExecutionStatus;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TracingUtil;
import androidx.test.espresso.util.concurrent.ListenableFutureTask;
import androidx.test.espresso.util.concurrent.ListeningExecutorService;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.LogUtil;
import androidx.test.platform.tracing.Tracer;
import androidx.test.platform.tracing.Tracing;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewInteraction {
    private static final String TAG = ViewInteraction.class.getSimpleName();
    private final InterruptableUiController uiController;
    private final ViewFinder viewFinder;
    private final Executor mainThreadExecutor;
    private final ControlledLooper controlledLooper;
    private volatile FailureHandler failureHandler;
    private final Matcher<View> viewMatcher;
    private final AtomicReference<Matcher<Root>> rootMatcherRef;
    private final AtomicReference<Boolean> needsActivity;
    private final RemoteInteraction remoteInteraction;
    private final ListeningExecutorService remoteExecutor;
    private final TestFlowVisualizer testFlowVisualizer;
    private final Tracing tracer;
    private boolean hasRootMatcher = false;

    @Inject
    ViewInteraction(UiController uiController, ViewFinder viewFinder, @MainThread Executor mainThreadExecutor, FailureHandler failureHandler, Matcher<View> viewMatcher, AtomicReference<Matcher<Root>> rootMatcherRef, AtomicReference<Boolean> needsActivity, RemoteInteraction remoteInteraction, ListeningExecutorService remoteExecutor, ControlledLooper controlledLooper, TestFlowVisualizer testFlowVisualizer, Tracing tracer) {
        this.viewFinder = (ViewFinder)Checks.checkNotNull((Object)viewFinder);
        this.uiController = (InterruptableUiController)Checks.checkNotNull((Object)uiController);
        this.failureHandler = (FailureHandler)Checks.checkNotNull((Object)failureHandler);
        this.mainThreadExecutor = (Executor)Checks.checkNotNull((Object)mainThreadExecutor);
        this.viewMatcher = (Matcher)Checks.checkNotNull(viewMatcher);
        this.rootMatcherRef = (AtomicReference)Checks.checkNotNull(rootMatcherRef);
        this.needsActivity = (AtomicReference)Checks.checkNotNull(needsActivity);
        this.remoteInteraction = (RemoteInteraction)Checks.checkNotNull((Object)remoteInteraction);
        this.remoteExecutor = (ListeningExecutorService)Checks.checkNotNull((Object)remoteExecutor);
        this.controlledLooper = (ControlledLooper)Checks.checkNotNull((Object)controlledLooper);
        this.testFlowVisualizer = (TestFlowVisualizer)Checks.checkNotNull((Object)testFlowVisualizer);
        this.tracer = tracer;
    }

    public ViewInteraction perform(ViewAction ... viewActions) {
        Checks.checkNotNull((Object)viewActions);
        for (ViewAction va : viewActions) {
            int actionIndex = this.testFlowVisualizer.getLastActionIndexAndIncrement();
            boolean testFlowEnabled = this.testFlowVisualizer.isEnabled();
            if (testFlowEnabled) {
                this.testFlowVisualizer.beforeActionGenerateTestArtifact(actionIndex);
            }
            SingleExecutionViewAction singleExecutionViewAction = new SingleExecutionViewAction(va, this.viewMatcher);
            this.desugaredPerform(singleExecutionViewAction, actionIndex, testFlowEnabled);
            if (!testFlowEnabled) continue;
            this.testFlowVisualizer.afterActionGenerateTestArtifact(actionIndex);
        }
        return this;
    }

    private static Map<String, IBinder> getIBindersFromBindables(List<Bindable> bindables) {
        HashMap<String, IBinder> iBinders = new HashMap<String, IBinder>();
        for (Bindable bindable : bindables) {
            iBinders.put((String)Checks.checkNotNull((Object)bindable.getId(), (Object)"Bindable id cannot be null!"), (IBinder)Checks.checkNotNull((Object)bindable.getIBinder(), (Object)"Bindable binder cannot be null!"));
        }
        return Collections.unmodifiableMap(iBinders);
    }

    private static List<Bindable> getBindables(Object ... objects) {
        ArrayList<Bindable> bindables = new ArrayList<Bindable>(objects.length);
        for (Object object : objects) {
            if (!(object instanceof Bindable)) continue;
            bindables.add((Bindable)object);
        }
        return bindables;
    }

    private static Map<String, IBinder> getIBindersFromViewActions(ViewAction ... viewActions) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewActions));
    }

    private static Map<String, IBinder> getIBindersFromViewAssertions(ViewAssertion ... viewAssertions) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewAssertions));
    }

    private void desugaredPerform(final SingleExecutionViewAction va, final int actionIndex, final boolean testFlowEnabled) {
        final ViewAction innerViewAction = va.getInnerViewAction();
        Callable<Void> performInteraction = new Callable<Void>(){

            @Override
            public Void call() {
                String spanName = TracingUtil.getSpanName("Espresso", "perform", TracingUtil.getClassName(innerViewAction, innerViewAction.getDescription()), ViewInteraction.this.viewMatcher);
                try (Tracer.Span ignored = ViewInteraction.this.tracer.beginSpan(spanName);){
                    ViewInteraction.this.doPerform(va, actionIndex, testFlowEnabled);
                }
                return null;
            }
        };
        ArrayList<ListenableFuture<Void>> interactions = new ArrayList<ListenableFuture<Void>>();
        interactions.add(this.postAsynchronouslyOnUiThread(performInteraction));
        if (!this.remoteInteraction.isRemoteProcess() && this.remoteInteraction.isRemoteClient()) {
            interactions.add(this.remoteExecutor.submit(this.remoteInteraction.createRemotePerformCallable(this.rootMatcherRef.get(), this.viewMatcher, ViewInteraction.getIBindersFromViewActions(va, innerViewAction), innerViewAction)));
        }
        this.waitForAndHandleInteractionResults(interactions);
    }

    public ViewInteraction withFailureHandler(FailureHandler failureHandler) {
        this.failureHandler = (FailureHandler)Checks.checkNotNull((Object)failureHandler);
        return this;
    }

    public ViewInteraction inRoot(Matcher<Root> rootMatcher) {
        this.hasRootMatcher = true;
        this.rootMatcherRef.set((Matcher<Root>)((Matcher)Checks.checkNotNull(rootMatcher)));
        return this;
    }

    public ViewInteraction noActivity() {
        if (!this.hasRootMatcher) {
            this.rootMatcherRef.set((Matcher<Root>)Matchers.anyOf(RootMatchers.DEFAULT, (Matcher)Matchers.allOf(RootMatchers.hasWindowLayoutParams(), RootMatchers.isSystemAlertWindow())));
        }
        this.needsActivity.set(false);
        return this;
    }

    private void doPerform(SingleExecutionViewAction viewAction, int actionIndex, boolean testFlowEnabled) {
        Checks.checkNotNull((Object)viewAction);
        Matcher constraints = (Matcher)Checks.checkNotNull(viewAction.getConstraints());
        this.uiController.loopMainThreadUntilIdle();
        View targetView = this.viewFinder.getView();
        Log.i((String)TAG, (String)String.format(Locale.ROOT, "Performing '%s' action on view %s", viewAction.getDescription(), this.viewMatcher));
        if (!constraints.matches((Object)targetView)) {
            StringDescription stringDescription = new StringDescription((Appendable)new StringBuilder("Action will not be performed because the target view does not match one or more of the following constraints:\n"));
            constraints.describeTo((Description)stringDescription);
            stringDescription.appendText("\nTarget view: ").appendValue((Object)HumanReadables.describe(targetView));
            if (viewAction.getInnerViewAction() instanceof ScrollToAction && ViewMatchers.isDescendantOfA(ViewMatchers.isAssignableFrom(AdapterView.class)).matches((Object)targetView)) {
                stringDescription.appendText("\nFurther Info: ScrollToAction on a view inside an AdapterView will not work. Use Espresso.onData to load the view.");
            }
            throw new PerformException.Builder().withActionDescription(viewAction.getDescription()).withViewDescription(this.viewMatcher.toString()).withCause(new RuntimeException(stringDescription.toString())).build();
        }
        ActionData actionData = new ActionData(actionIndex, viewAction.viewAction);
        if (testFlowEnabled) {
            this.testFlowVisualizer.beforeActionRecordData(actionData, targetView);
        }
        String spanName = TracingUtil.getSpanName("Espresso", "doPerform", HumanReadables.describe(targetView));
        try (Tracer.Span ignored = this.tracer.beginSpan(spanName);){
            viewAction.perform(this.uiController, targetView);
        }
        if (testFlowEnabled) {
            this.testFlowVisualizer.afterActionRecordData(actionData);
        }
    }

    public ViewInteraction check(final ViewAssertion viewAssert) {
        Checks.checkNotNull((Object)viewAssert);
        final SingleExecutionViewAssertion singleExecutionViewAssertion = new SingleExecutionViewAssertion(viewAssert);
        Callable<Void> checkInteraction = new Callable<Void>(){

            @Override
            public Void call() {
                String spanName = TracingUtil.getSpanName("Espresso", "check", TracingUtil.getClassName(viewAssert, "ViewAssertion"), ViewInteraction.this.viewMatcher);
                try (Tracer.Span ignored = ViewInteraction.this.tracer.beginSpan(spanName);){
                    Void void_;
                    block14: {
                        ViewInteraction.this.uiController.loopMainThreadUntilIdle();
                        View targetView = null;
                        NoMatchingViewException missingViewException = null;
                        try {
                            targetView = ViewInteraction.this.viewFinder.getView();
                        }
                        catch (NoMatchingViewException nsve) {
                            missingViewException = nsve;
                        }
                        Log.i((String)TAG, (String)String.format(Locale.ROOT, "Checking '%s' assertion on view %s", viewAssert, ViewInteraction.this.viewMatcher));
                        String checkOnTargetViewSpan = TracingUtil.getSpanName("Espresso", "doCheck", HumanReadables.describe(targetView));
                        Tracer.Span checkOnTargetViewSpanIgnored = ViewInteraction.this.tracer.beginSpan(checkOnTargetViewSpan);
                        try {
                            singleExecutionViewAssertion.check(targetView, missingViewException);
                            void_ = null;
                            if (checkOnTargetViewSpanIgnored == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (checkOnTargetViewSpanIgnored != null) {
                                try {
                                    checkOnTargetViewSpanIgnored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        checkOnTargetViewSpanIgnored.close();
                    }
                    return void_;
                }
            }
        };
        ArrayList<ListenableFuture<Void>> interactions = new ArrayList<ListenableFuture<Void>>();
        interactions.add(this.postAsynchronouslyOnUiThread(checkInteraction));
        if (!this.remoteInteraction.isRemoteProcess() && this.remoteInteraction.isRemoteClient()) {
            interactions.add(this.remoteExecutor.submit(this.remoteInteraction.createRemoteCheckCallable(this.rootMatcherRef.get(), this.viewMatcher, ViewInteraction.getIBindersFromViewAssertions(singleExecutionViewAssertion, viewAssert), viewAssert)));
        }
        this.waitForAndHandleInteractionResults(interactions);
        return this;
    }

    private ListenableFuture<Void> postAsynchronouslyOnUiThread(Callable<Void> interaction) {
        Checks.checkNotMainThread();
        ListenableFutureTask<Void> mainThreadInteraction = ListenableFutureTask.create(interaction);
        this.mainThreadExecutor.execute(mainThreadInteraction);
        return mainThreadInteraction;
    }

    private void waitForAndHandleInteractionResults(List<ListenableFuture<Void>> interactions) {
        try {
            this.controlledLooper.drainMainThreadUntilIdle();
            InteractionResultsHandler.gatherAnyResult(interactions);
        }
        catch (RuntimeException ee) {
            this.failureHandler.handle(ee, this.viewMatcher);
        }
        catch (Error error) {
            this.failureHandler.handle(error, this.viewMatcher);
        }
        finally {
            this.uiController.interruptEspressoTasks();
        }
    }

    private static final class SingleExecutionViewAssertion
    implements ViewAssertion,
    Bindable {
        final ViewAssertion viewAssertion;
        private IInteractionExecutionStatus assertionExecutionStatus = new IInteractionExecutionStatus.Stub(){
            AtomicBoolean run = new AtomicBoolean(true);

            @Override
            public boolean canExecute() throws RemoteException {
                return this.run.getAndSet(false);
            }
        };

        private SingleExecutionViewAssertion(ViewAssertion viewAssertion) {
            this.viewAssertion = viewAssertion;
        }

        @Override
        public void check(View view, NoMatchingViewException noViewFoundException) {
            try {
                if (this.assertionExecutionStatus.canExecute()) {
                    this.viewAssertion.check(view, noViewFoundException);
                } else {
                    LogUtil.logDebugWithProcess((String)TAG, (String)("Attempted to execute a Single Execution Assertion more then once: " + this.viewAssertion), (Object[])new Object[0]);
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Unable to query interaction execution status", e.getCause());
            }
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.assertionExecutionStatus.asBinder();
        }

        @Override
        public void setIBinder(IBinder binder) {
            this.assertionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface(binder);
        }
    }

    private static final class SingleExecutionViewAction
    implements ViewAction,
    Bindable {
        final ViewAction viewAction;
        final Matcher<View> viewMatcher;
        private IInteractionExecutionStatus actionExecutionStatus = new IInteractionExecutionStatus.Stub(){
            AtomicBoolean run = new AtomicBoolean(true);

            @Override
            public boolean canExecute() throws RemoteException {
                return this.run.getAndSet(false);
            }
        };

        private SingleExecutionViewAction(ViewAction viewAction, Matcher<View> viewMatcher) {
            this.viewAction = viewAction;
            this.viewMatcher = viewMatcher;
        }

        @Override
        public Matcher<View> getConstraints() {
            return this.viewAction.getConstraints();
        }

        @Override
        public String getDescription() {
            return this.viewAction.getDescription();
        }

        @Override
        public void perform(UiController uiController, View view) {
            try {
                if (this.actionExecutionStatus.canExecute()) {
                    this.viewAction.perform(uiController, view);
                } else {
                    LogUtil.logDebugWithProcess((String)TAG, (String)("Attempted to execute a Single Execution Action more then once: " + this.viewAction), (Object[])new Object[0]);
                }
            }
            catch (RemoteException e) {
                throw new PerformException.Builder().withActionDescription(this.viewAction.getDescription()).withViewDescription(this.viewMatcher.toString()).withCause(new RuntimeException("Unable to query interaction execution status", e.getCause())).build();
            }
        }

        ViewAction getInnerViewAction() {
            return this.viewAction;
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public IBinder getIBinder() {
            return this.actionExecutionStatus.asBinder();
        }

        @Override
        public void setIBinder(IBinder binder) {
            this.actionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface(binder);
        }
    }
}

