/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.ToStringHelper;
import androidx.test.internal.util.Checks;

public final class Root {
    private final View decorView;
    @Nullable
    private final WindowManager.LayoutParams windowLayoutParams;

    private Root(Builder builder) {
        this.decorView = (View)Checks.checkNotNull((Object)builder.decorView);
        this.windowLayoutParams = builder.windowLayoutParams;
    }

    public View getDecorView() {
        return this.decorView;
    }

    @Deprecated
    public EspressoOptional<WindowManager.LayoutParams> getWindowLayoutParams() {
        return EspressoOptional.of(this.windowLayoutParams);
    }

    public WindowManager.LayoutParams getWindowLayoutParams2() {
        return this.windowLayoutParams;
    }

    public boolean isReady() {
        if (!this.decorView.isLayoutRequested()) {
            int flags = this.windowLayoutParams.flags;
            return this.decorView.hasWindowFocus() || (flags & 8) == 8;
        }
        return false;
    }

    public String toString() {
        ToStringHelper helper = new ToStringHelper(this).add("application-window-token", this.decorView.getApplicationWindowToken()).add("window-token", this.decorView.getWindowToken()).add("has-window-focus", this.decorView.hasWindowFocus());
        if (this.windowLayoutParams != null) {
            helper.add("layout-params-type", this.windowLayoutParams.type).add("layout-params-string", this.windowLayoutParams);
        }
        helper.add("decor-view-string", HumanReadables.describe(this.decorView));
        return helper.toString();
    }

    public static class Builder {
        private View decorView;
        private WindowManager.LayoutParams windowLayoutParams;

        public Root build() {
            return new Root(this);
        }

        public Builder withDecorView(View view) {
            this.decorView = view;
            return this;
        }

        public Builder withWindowLayoutParams(WindowManager.LayoutParams windowLayoutParams) {
            this.windowLayoutParams = windowLayoutParams;
            return this;
        }
    }
}

