/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.EspressoException;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import java.util.Locale;

public final class PerformException
extends RuntimeException
implements EspressoException {
    private static final String MESSAGE_FORMAT = "Error performing '%s' on view '%s'.";
    private final String actionDescription;
    private final String viewDescription;

    private PerformException(Builder builder) {
        super(String.format(Locale.ROOT, MESSAGE_FORMAT, builder.actionDescription, builder.viewDescription), builder.cause);
        this.actionDescription = (String)Checks.checkNotNull((Object)builder.actionDescription);
        this.viewDescription = (String)Checks.checkNotNull((Object)builder.viewDescription);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-PerformException.txt");
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public String getViewDescription() {
        return this.viewDescription;
    }

    public static class Builder {
        private String actionDescription;
        private String viewDescription;
        private Throwable cause;

        public Builder from(PerformException instance) {
            this.actionDescription = instance.getActionDescription();
            this.viewDescription = instance.getViewDescription();
            this.cause = instance.getCause();
            return this;
        }

        public Builder withActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public Builder withViewDescription(String viewDescription) {
            this.viewDescription = viewDescription;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public PerformException build() {
            return new PerformException(this);
        }
    }
}

