/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.espresso.RootViewException;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class NoMatchingViewException
extends RuntimeException
implements RootViewException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private List<View> adapterViews = new ArrayList<View>();
    private boolean includeViewHierarchy = true;
    @Nullable
    private String adapterViewWarning = null;

    private NoMatchingViewException(Builder builder) {
        super(NoMatchingViewException.getErrorMessage(builder), builder.cause);
        this.viewMatcher = builder.viewMatcher;
        this.rootView = builder.rootView;
        this.adapterViews = builder.adapterViews;
        this.adapterViewWarning = builder.adapterViewWarning;
        this.includeViewHierarchy = builder.includeViewHierarchy;
    }

    public String getViewMatcherDescription() {
        String viewMatcherDescription = "unknown";
        if (null != this.viewMatcher) {
            viewMatcherDescription = this.viewMatcher.toString();
        }
        return viewMatcherDescription;
    }

    @Override
    public View getRootView() {
        return this.rootView;
    }

    private static String getErrorMessage(Builder builder) {
        String errorMessage = "";
        if (builder.includeViewHierarchy) {
            String message = String.format(Locale.ROOT, "No views in hierarchy found matching: %s", builder.viewMatcher);
            if (builder.adapterViewWarning != null) {
                message = message + builder.adapterViewWarning;
            }
            errorMessage = HumanReadables.getViewHierarchyErrorMessage(builder.rootView, null, message, null, builder.maxMsgLen);
            if (builder.viewHierarchyFile != null) {
                errorMessage = errorMessage + String.format("\nThe complete view hierarchy is available in artifact file '%s'.", builder.viewHierarchyFile);
            }
        } else {
            errorMessage = String.format(Locale.ROOT, "Could not find a view that matches %s", builder.viewMatcher);
        }
        return errorMessage;
    }

    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private List<View> adapterViews = new ArrayList<View>();
        private boolean includeViewHierarchy = true;
        @Nullable
        private String adapterViewWarning = null;
        private Throwable cause;
        private int maxMsgLen = Integer.MAX_VALUE;
        private String viewHierarchyFile = null;

        public Builder from(NoMatchingViewException exception) {
            this.viewMatcher = exception.viewMatcher;
            this.rootView = exception.rootView;
            this.adapterViews = exception.adapterViews;
            this.adapterViewWarning = exception.adapterViewWarning;
            this.includeViewHierarchy = exception.includeViewHierarchy;
            return this;
        }

        public Builder withViewMatcher(Matcher<? super View> viewMatcher) {
            this.viewMatcher = viewMatcher;
            return this;
        }

        public Builder withRootView(View rootView) {
            this.rootView = rootView;
            return this;
        }

        public Builder withAdapterViews(List<View> adapterViews) {
            this.adapterViews = adapterViews;
            return this;
        }

        public Builder includeViewHierarchy(boolean includeViewHierarchy) {
            this.includeViewHierarchy = includeViewHierarchy;
            return this;
        }

        @Deprecated
        public Builder withAdapterViewWarning(EspressoOptional<String> adapterViewWarning) {
            return this.withAdapterViewWarning(adapterViewWarning.get());
        }

        @CanIgnoreReturnValue
        public Builder withAdapterViewWarning(String adapterViewWarning) {
            this.adapterViewWarning = adapterViewWarning;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @NonNull
        public Builder withMaxMsgLen(int maxMsgLen) {
            this.maxMsgLen = maxMsgLen;
            return this;
        }

        @NonNull
        public Builder withViewHierarchyFile(@Nullable String viewHierarchyFile) {
            this.viewHierarchyFile = viewHierarchyFile;
            return this;
        }

        public NoMatchingViewException build() {
            Checks.checkNotNull(this.viewMatcher);
            Checks.checkNotNull((Object)this.rootView);
            Checks.checkNotNull(this.adapterViews);
            return new NoMatchingViewException(this);
        }
    }
}

