/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.EspressoException;
import androidx.test.espresso.Root;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class NoMatchingRootException
extends RuntimeException
implements EspressoException {
    private NoMatchingRootException(String description) {
        super(description);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-NoMatchingRootException.txt");
    }

    public static NoMatchingRootException create(Matcher<Root> rootMatcher, List<Root> roots) {
        Checks.checkNotNull(rootMatcher);
        Checks.checkNotNull(roots);
        return new NoMatchingRootException(String.format(Locale.ROOT, "Matcher '%s' did not match any of the following roots: %s", rootMatcher, roots));
    }
}

