/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.remote.NoRemoteEspressoInstanceException;
import androidx.test.espresso.util.ToStringHelper;
import androidx.test.internal.util.Checks;
import androidx.test.platform.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

@VisibleForTesting
final class InteractionResultsHandler {
    private static final String TAG = "InteractionResultsHandl";
    private static final int LOCAL_OR_REMOTE_ERROR_PRIORITY = Integer.MAX_VALUE;

    private InteractionResultsHandler() {
    }

    static <T> T gatherAnyResult(List<ListenableFuture<T>> tasks) {
        return InteractionResultsHandler.gatherAnyResult(tasks, (Executor)DirectExecutor.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static <T> T gatherAnyResult(List<ListenableFuture<T>> tasks, Executor executor) {
        Object t;
        Checks.checkNotNull(tasks);
        Checks.checkState((!tasks.isEmpty() ? 1 : 0) != 0);
        int active = tasks.size();
        final LinkedBlockingQueue resultQ = new LinkedBlockingQueue(active);
        Iterator<ListenableFuture<T>> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            final ListenableFuture<T> myTask = t = iterator.next();
            myTask.addListener(new Runnable(){

                @Override
                public void run() {
                    if (myTask.isCancelled()) {
                        return;
                    }
                    resultQ.offer(InteractionResultsHandler.adaptResult((Future)myTask));
                }
            }, executor);
        }
        ExecutionResult<T> bestResult = null;
        try {
            while (true) {
                if (active == 0 || bestResult != null && bestResult.isPriority()) {
                    t = InteractionResultsHandler.finalResult(bestResult);
                    return (T)t;
                }
                ExecutionResult result = (ExecutionResult)resultQ.take();
                --active;
                bestResult = InteractionResultsHandler.pickResult(bestResult, result);
                continue;
                break;
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted while interacting", ie);
        }
        finally {
            Iterator<ListenableFuture<T>> iterator2 = tasks.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                }
                ListenableFuture<T> t2 = iterator2.next();
                t2.cancel(true);
            }
        }
    }

    private static <T> T finalResult(ExecutionResult<T> result) {
        if (result.isSuccess()) {
            return result.getResult();
        }
        Throwable t = result.getFailure();
        if (t instanceof ExecutionException) {
            Throwable cause = t.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unknown error during interactions", result.getFailure());
        }
        if (t instanceof InterruptedException) {
            throw new IllegalStateException("Interrupted while interacting remotely", t);
        }
        throw new RuntimeException("Error interacting remotely", t);
    }

    private static <T> ExecutionResult<T> adaptResult(Future<T> task) {
        try {
            Checks.checkState((boolean)task.isDone());
            return ExecutionResult.success(task.get());
        }
        catch (ExecutionException ex) {
            return ExecutionResult.error(ex, Integer.MAX_VALUE == InteractionResultsHandler.getPriority(ex));
        }
        catch (InterruptedException ie) {
            return ExecutionResult.error(ie);
        }
        catch (RuntimeException re) {
            return ExecutionResult.error(re);
        }
        catch (Error e) {
            return ExecutionResult.error(e);
        }
    }

    private static <T> ExecutionResult<T> pickResult(ExecutionResult<T> one, ExecutionResult<T> two) {
        if (two == null) {
            return one;
        }
        if (one == null) {
            return two;
        }
        if (one.isSuccess()) {
            return one;
        }
        if (two.isSuccess()) {
            return two;
        }
        if (InteractionResultsHandler.getPriority(one.getFailure()) > InteractionResultsHandler.getPriority(two.getFailure())) {
            return one;
        }
        return two;
    }

    private static int getPriority(Throwable t) {
        if (null == t) {
            return Integer.MIN_VALUE;
        }
        if (!(t instanceof ExecutionException)) {
            return -2147483647;
        }
        if (t.getCause() instanceof NoRemoteEspressoInstanceException) {
            return 0;
        }
        if (t.getCause() instanceof NoActivityResumedException) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private static class ExecutionResult<T> {
        private final T result;
        private final boolean success;
        private final Throwable failure;
        private final boolean priority;

        private ExecutionResult(T result, boolean success, Throwable failure, boolean priority) {
            this.result = result;
            this.success = success;
            this.failure = failure;
            this.priority = priority;
        }

        public T getResult() {
            Checks.checkState((boolean)this.success);
            return this.result;
        }

        public boolean isPriority() {
            return this.priority;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Throwable getFailure() {
            Checks.checkState((!this.success ? 1 : 0) != 0);
            return this.failure;
        }

        public static <T> ExecutionResult<T> success(T result) {
            return new ExecutionResult<T>(result, true, null, true);
        }

        public static <T> ExecutionResult<T> error(Throwable error) {
            return ExecutionResult.error(error, false);
        }

        public static <T> ExecutionResult<T> error(Throwable error, boolean priorityFailure) {
            return new ExecutionResult<Object>(null, false, error, priorityFailure);
        }

        public String toString() {
            return new ToStringHelper(this).add("priority", this.priority).add("success", this.success).add("result", this.result).add("failure", this.failure).toString();
        }
    }
}

