/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.util.Log;
import androidx.test.espresso.AppNotIdleException;
import androidx.test.espresso.IdlingResourceTimeoutException;
import androidx.test.internal.util.Checks;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class IdlingPolicy {
    private static final String TAG = "IdlingPolicy";
    private final long idleTimeout;
    private final TimeUnit unit;
    private final ResponseAction errorHandler;
    private final boolean timeoutIfDebuggerAttached;
    private final boolean disableOnTimeout;

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.unit;
    }

    public void handleTimeout(List<String> busyResources, String message) {
        switch (this.errorHandler) {
            case THROW_APP_NOT_IDLE: {
                throw AppNotIdleException.create(busyResources, message);
            }
            case THROW_IDLE_TIMEOUT: {
                throw new IdlingResourceTimeoutException(busyResources);
            }
            case LOG_ERROR: {
                Log.w((String)TAG, (String)("These resources are not idle: " + busyResources));
                break;
            }
            default: {
                throw new IllegalStateException("should never reach here." + busyResources);
            }
        }
    }

    public boolean getTimeoutIfDebuggerAttached() {
        return this.timeoutIfDebuggerAttached;
    }

    public boolean getDisableOnTimeout() {
        return this.disableOnTimeout;
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    private IdlingPolicy(Builder builder) {
        Checks.checkArgument((builder.idleTimeout > 0L ? 1 : 0) != 0);
        this.idleTimeout = builder.idleTimeout;
        this.unit = (TimeUnit)((Object)Checks.checkNotNull((Object)((Object)builder.unit)));
        this.errorHandler = (ResponseAction)((Object)Checks.checkNotNull((Object)((Object)builder.errorHandler)));
        this.timeoutIfDebuggerAttached = builder.timeoutIfDebuggerAttached;
        this.disableOnTimeout = builder.disableOnTimeout;
    }

    static class Builder {
        private long idleTimeout = -1L;
        private TimeUnit unit = null;
        private ResponseAction errorHandler = null;
        private boolean timeoutIfDebuggerAttached = false;
        private boolean disableOnTimeout;

        public Builder() {
        }

        private Builder(IdlingPolicy copy) {
            this.idleTimeout = copy.idleTimeout;
            this.unit = copy.unit;
            this.errorHandler = copy.errorHandler;
        }

        public IdlingPolicy build() {
            return new IdlingPolicy(this);
        }

        public Builder withTimeoutIfDebuggerAttached(boolean timeoutIfDebuggerAttached) {
            this.timeoutIfDebuggerAttached = timeoutIfDebuggerAttached;
            return this;
        }

        public Builder withDisableOnTimeout(boolean disableOnTimeout) {
            this.disableOnTimeout = disableOnTimeout;
            return this;
        }

        public Builder withIdlingTimeout(long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder withIdlingTimeoutUnit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder throwAppNotIdleException() {
            this.errorHandler = ResponseAction.THROW_APP_NOT_IDLE;
            return this;
        }

        public Builder throwIdlingResourceTimeoutException() {
            this.errorHandler = ResponseAction.THROW_IDLE_TIMEOUT;
            return this;
        }

        public Builder logWarning() {
            this.errorHandler = ResponseAction.LOG_ERROR;
            return this;
        }
    }

    private static enum ResponseAction {
        THROW_APP_NOT_IDLE,
        THROW_IDLE_TIMEOUT,
        LOG_ERROR;

    }
}

